/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.mobile.sdk;

import com.liferay.mobile.sdk.Builder;
import com.liferay.mobile.sdk.http.Action;
import com.liferay.mobile.sdk.http.Discovery;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class BaseBuilder
implements Builder {
    protected static final String ACTIONS = "actions";
    protected static final String BYTE_ARRAY = "BYTE_ARRAY";
    protected static final String CLASS_NAME = "className";
    protected static final String DISCOVERY = "discovery";
    protected static final String ESCAPE_TOOL = "esc";
    protected static final String JSON_OBJECT_WRAPPER = "JSON_OBJECT_WRAPPER";
    protected static final String LANGUAGE_UTIL = "languageUtil";
    protected static final String VOID = "VOID";
    private static final Logger _log = Logger.getLogger(BaseBuilder.class.getName());

    @Override
    public void buildAll(Discovery discovery, String packageName, int version, String destination) {
        HashMap<String, ArrayList<Action>> actionsMap = new HashMap<String, ArrayList<Action>>();
        List<Action> actions = discovery.getActions();
        for (Action action : actions) {
            String path = action.getPath();
            int index = path.indexOf("/", 1);
            if (index == -1) {
                _log.log(Level.WARNING, "Action {0} skipped, unexpected path format", action.getPath());
                continue;
            }
            String className = path.substring(1, index);
            ArrayList<Action> classActions = (ArrayList<Action>)actionsMap.get(className);
            if (classActions == null) {
                classActions = new ArrayList<Action>();
                actionsMap.put(className, classActions);
            }
            classActions.add(action);
        }
        for (Map.Entry entry : actionsMap.entrySet()) {
            try {
                this.build(discovery, (List)entry.getValue(), packageName, version, (String)entry.getKey(), destination);
            }
            catch (Exception e) {
                _log.log(Level.SEVERE, "Could not generate classes for action " + (String)entry.getKey(), e);
            }
        }
    }
}

