/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.mobile.android.service;

import com.liferay.mobile.android.util.Validator;
import java.util.Iterator;
import org.json.JSONException;
import org.json.JSONObject;

public class JSONObjectWrapper {
    private String _className;
    private JSONObject _jsonObject;

    public JSONObjectWrapper(JSONObject jsonObject) {
        this(null, jsonObject);
    }

    public JSONObjectWrapper(String className, JSONObject jsonObject) {
        this._className = className;
        this._jsonObject = jsonObject;
    }

    public String getClassName() {
        return this._className;
    }

    public JSONObject getJSONObject() {
        return this._jsonObject;
    }

    public void mangle(JSONObject params, String name, String className) throws JSONException {
        this.addClassName(params, name, className);
        this.addJSONObject(params, name);
    }

    public void setClassName(String className) {
        this._className = className;
    }

    public void setJSONObject(JSONObject jsonObject) {
        this._jsonObject = jsonObject;
    }

    protected void addClassName(JSONObject params, String name, String className) throws JSONException {
        StringBuilder sb = new StringBuilder();
        sb.append('+');
        sb.append(name);
        if (Validator.isNull(this._className)) {
            this._className = className;
        }
        params.put(sb.toString(), (Object)this._className);
    }

    protected void addJSONObject(JSONObject params, String name) throws JSONException {
        Iterator it = this._jsonObject.keys();
        while (it.hasNext()) {
            String key = (String)it.next();
            Object value = this._jsonObject.get(key);
            StringBuilder sb = new StringBuilder();
            sb.append(name);
            sb.append('.');
            sb.append(key);
            params.put(sb.toString(), value);
        }
    }
}

