/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.mobile.android.auth.oauth2;

import com.liferay.mobile.android.auth.Authentication;
import com.liferay.mobile.android.http.Request;
import java.util.List;
import java.util.Map;

public class OAuth2Authentication
implements Authentication {
    private String accessToken;
    private String refreshToken;
    private List<String> scope;
    private long accessTokenExpirationDate;
    private String clientId;
    private String clientSecret;

    public OAuth2Authentication(String accessToken, String refreshToken, List<String> scope, long accessTokenExpirationDate, String clientId, String clientSecret) {
        this.accessToken = accessToken;
        this.refreshToken = refreshToken;
        this.scope = scope;
        this.accessTokenExpirationDate = accessTokenExpirationDate;
        this.clientId = clientId;
        this.clientSecret = clientSecret;
    }

    @Override
    public void authenticate(Request request) {
        Map<String, String> headers = request.getHeaders();
        headers.put("Authorization", "Bearer " + this.accessToken);
    }

    public String getAccessToken() {
        return this.accessToken;
    }

    public void setAccessToken(String accessToken) {
        this.accessToken = accessToken;
    }

    public String getRefreshToken() {
        return this.refreshToken;
    }

    public void setRefreshToken(String refreshToken) {
        this.refreshToken = refreshToken;
    }

    public List<String> getScope() {
        return this.scope;
    }

    public void setScope(List<String> scope) {
        this.scope = scope;
    }

    public long getAccessTokenExpirationDate() {
        return this.accessTokenExpirationDate;
    }

    public void setAccessTokenExpirationDate(long accessTokenExpirationDate) {
        this.accessTokenExpirationDate = accessTokenExpirationDate;
    }

    public String getClientId() {
        return this.clientId;
    }

    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    public String getClientSecret() {
        return this.clientSecret;
    }

    public void setClientSecret(String clientSecret) {
        this.clientSecret = clientSecret;
    }
}

