/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.mobile.android.auth.basic;

import com.liferay.mobile.android.auth.basic.BasicAuthentication;
import com.liferay.mobile.android.http.Request;
import com.squareup.okhttp.Authenticator;
import com.squareup.okhttp.Request;
import com.squareup.okhttp.Response;
import java.io.IOException;
import java.net.Proxy;
import org.apache.http.Header;
import org.apache.http.HttpRequest;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.impl.auth.DigestScheme;
import org.apache.http.message.BasicHeader;
import org.apache.http.message.BasicHttpRequest;

public class DigestAuthentication
extends BasicAuthentication
implements Authenticator {
    public DigestAuthentication(String username, String password) {
        super(username, password);
    }

    @Override
    public void authenticate(Request request) {
    }

    public com.squareup.okhttp.Request authenticate(Proxy proxy, Response response) throws IOException {
        com.squareup.okhttp.Request request = response.request();
        Request.Builder builder = request.newBuilder();
        try {
            BasicHeader authenticateHeader = new BasicHeader("WWW-Authenticate", response.header("WWW-Authenticate"));
            DigestScheme scheme = new DigestScheme();
            scheme.processChallenge((Header)authenticateHeader);
            BasicHttpRequest basicHttpRequest = new BasicHttpRequest(request.method(), request.uri().getPath());
            UsernamePasswordCredentials credentials = new UsernamePasswordCredentials(this.username, this.password);
            String authorizationHeader = scheme.authenticate((Credentials)credentials, (HttpRequest)basicHttpRequest).getValue();
            builder.addHeader("Authorization", authorizationHeader);
        }
        catch (Exception e) {
            throw new IOException(e);
        }
        return builder.build();
    }

    public com.squareup.okhttp.Request authenticateProxy(Proxy proxy, Response response) throws IOException {
        return null;
    }
}

