/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.mobile.android.http;

import com.liferay.mobile.android.callback.BaseCallback;
import com.liferay.mobile.android.callback.Callback;
import com.liferay.mobile.android.callback.file.DownloadCallback;
import com.liferay.mobile.android.callback.file.FileProgressCallback;
import com.liferay.mobile.android.callback.file.UploadCallback;
import com.liferay.mobile.android.http.Method;
import com.liferay.mobile.android.http.Request;
import com.liferay.mobile.android.http.Response;
import com.liferay.mobile.android.http.client.HttpClient;
import com.liferay.mobile.android.http.client.OkHttpClientImpl;
import com.liferay.mobile.android.http.file.FileProgressUtil;
import com.liferay.mobile.android.service.Session;
import org.json.JSONArray;
import org.json.JSONObject;

public class HttpUtil {
    public static final String JSONWS_PATH_61 = "api/secure/jsonws";
    public static final String JSONWS_PATH_62 = "api/jsonws";
    protected static HttpClient client = new OkHttpClientImpl();
    private static String _JSONWS_PATH = "api/jsonws";

    public static void cancel(Object tag) {
        client.cancel(tag);
    }

    public static Response download(Session session, String url, FileProgressCallback callback) throws Exception {
        Response response;
        Callback sessionCallback = session.getCallback();
        if (sessionCallback != null) {
            sessionCallback = new DownloadCallback(sessionCallback, callback);
        }
        Request request = new Request(session.getAuthentication(), Method.GET, session.getHeaders(), url, null, session.getConnectionTimeout(), sessionCallback);
        if (sessionCallback != null) {
            ((DownloadCallback)sessionCallback).setTag(request.getTag());
        }
        if ((response = HttpUtil.send(request)) == null) {
            return null;
        }
        FileProgressUtil.transfer(response.getBodyAsStream(), callback, request.getTag(), null);
        return response;
    }

    public static String encodeURLPath(String path) {
        return client.encodeURL(path);
    }

    public static String getURL(Session session, String path) {
        StringBuilder sb = new StringBuilder();
        String server = session.getServer();
        sb.append(server);
        if (!server.endsWith("/")) {
            sb.append("/");
        }
        sb.append(_JSONWS_PATH);
        sb.append(path);
        return sb.toString();
    }

    public static JSONArray post(Session session, JSONArray commands) throws Exception {
        String url = HttpUtil.getURL(session, "/invoke");
        Request request = new Request(session.getAuthentication(), Method.POST, session.getHeaders(), url, commands.toString(), session.getConnectionTimeout(), session.getCallback());
        Response response = client.send(request);
        if (response == null) {
            return null;
        }
        return new JSONArray(response.getBody());
    }

    public static JSONArray post(Session session, JSONObject command) throws Exception {
        JSONArray commands = new JSONArray();
        commands.put((Object)command);
        return HttpUtil.post(session, commands);
    }

    public static Response send(Request request) throws Exception {
        return client.send(request);
    }

    public static void setJSONWSPath(String jsonwsPath) {
        _JSONWS_PATH = jsonwsPath;
    }

    public static JSONArray upload(Session session, JSONObject command) throws Exception {
        Request request;
        Response response;
        String path = (String)command.keys().next();
        UploadCallback sessionCallback = session.getCallback();
        if (sessionCallback != null) {
            sessionCallback = new UploadCallback((BaseCallback)((Object)sessionCallback));
        }
        if ((response = client.upload(request = new Request(session.getAuthentication(), Method.POST, session.getHeaders(), HttpUtil.getURL(session, path), command.getJSONObject(path), session.getConnectionTimeout(), sessionCallback))) == null) {
            return null;
        }
        return new JSONArray(UploadCallback.wrap(response.getBody()));
    }
}

