/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.mobile.android.auth;

import com.liferay.mobile.android.auth.basic.BasicAuthentication;
import com.liferay.mobile.android.auth.basic.CookieAuthentication;
import com.liferay.mobile.android.exception.AuthenticationException;
import com.liferay.mobile.android.service.Session;
import com.liferay.mobile.android.service.SessionImpl;
import com.liferay.mobile.android.util.Validator;
import com.squareup.okhttp.Call;
import com.squareup.okhttp.Callback;
import com.squareup.okhttp.FormEncodingBuilder;
import com.squareup.okhttp.MediaType;
import com.squareup.okhttp.OkHttpClient;
import com.squareup.okhttp.Request;
import com.squareup.okhttp.RequestBody;
import com.squareup.okhttp.Response;
import java.io.IOException;
import java.net.CookieHandler;
import java.net.CookieManager;
import java.net.CookiePolicy;
import java.net.CookieStore;
import java.net.HttpCookie;
import okio.Buffer;
import okio.BufferedSink;

public class CookieSignIn {
    protected static final String AUTH_TOKEN = "Liferay.authToken=\"";
    protected static final int TOKEN_LENGTH = 8;

    public static void signIn(Session session, CookieCallback callback) {
        try {
            if (!(session.getAuthentication() instanceof BasicAuthentication)) {
                throw new Exception("Can't sign in if authentication implementation is not BasicAuthentication");
            }
            OkHttpClient client = new OkHttpClient();
            CookieManager cookieManager = new CookieManager();
            cookieManager.setCookiePolicy(CookiePolicy.ACCEPT_ALL);
            client.setCookieHandler((CookieHandler)cookieManager);
            client.setFollowRedirects(true);
            Request.Builder builder = new Request.Builder();
            MediaType contentType = MediaType.parse((String)"application/x-www-form-urlencoded");
            BasicAuthentication authentication = (BasicAuthentication)session.getAuthentication();
            builder.post(RequestBody.create((MediaType)contentType, (String)CookieSignIn.getBody(authentication)));
            builder.addHeader("Cookie", "COOKIE_SUPPORT=true;");
            builder.url(CookieSignIn.getLoginURL(session.getServer()));
            Call call = client.newCall(builder.build());
            call.enqueue(CookieSignIn.getCallback(session.getServer(), callback, cookieManager));
        }
        catch (Exception e) {
            callback.onFailure(e);
        }
    }

    protected static String getBody(BasicAuthentication authentication) throws IOException {
        RequestBody formBody = new FormEncodingBuilder().add("login", authentication.getUsername()).add("password", authentication.getPassword()).build();
        Buffer buffer = new Buffer();
        formBody.writeTo((BufferedSink)buffer);
        return buffer.readUtf8();
    }

    protected static Callback getCallback(final String server, final CookieCallback callback, final CookieManager cookieManager) {
        return new Callback(){

            public void onFailure(Request request, IOException ioe) {
                callback.onFailure(ioe);
            }

            public void onResponse(Response response) throws IOException {
                String body = response.body().string();
                Integer position = body.indexOf(CookieSignIn.AUTH_TOKEN) + CookieSignIn.AUTH_TOKEN.length();
                String authToken = body.substring(position, position + 8);
                String cookieHeader = CookieSignIn.getHttpCookies(cookieManager.getCookieStore());
                if (Validator.isNotNull(cookieHeader)) {
                    CookieAuthentication authentication = new CookieAuthentication(authToken, cookieHeader);
                    SessionImpl session = new SessionImpl(server, authentication);
                    callback.onSuccess(session);
                } else {
                    callback.onFailure(new AuthenticationException("Cookie invalid or empty"));
                }
            }
        };
    }

    protected static String getHttpCookies(CookieStore cookieStore) {
        StringBuilder cookies = new StringBuilder();
        for (HttpCookie cookie : cookieStore.getCookies()) {
            cookies.append(cookie);
            cookies.append(";");
        }
        return cookies.toString();
    }

    protected static String getLoginURL(String server) {
        if (!server.endsWith("/")) {
            server = server + "/";
        }
        return server + "c/portal/login";
    }

    public static interface CookieCallback {
        public void onSuccess(Session var1);

        public void onFailure(Exception var1);
    }
}

