/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.mobile.android.v7.bookmarksentry;

import com.liferay.mobile.android.service.BaseService;
import com.liferay.mobile.android.service.JSONObjectWrapper;
import com.liferay.mobile.android.service.Session;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class BookmarksEntryService
extends BaseService {
    public BookmarksEntryService(Session session) {
        super(session);
    }

    public JSONObject addEntry(long groupId, long folderId, String name, String url, String description, JSONObjectWrapper serviceContext) throws Exception {
        JSONObject _command = new JSONObject();
        try {
            JSONObject _params = new JSONObject();
            _params.put("groupId", groupId);
            _params.put("folderId", folderId);
            _params.put("name", this.checkNull(name));
            _params.put("url", this.checkNull(url));
            _params.put("description", this.checkNull(description));
            this.mangleWrapper(_params, "serviceContext", "com.liferay.portal.kernel.service.ServiceContext", serviceContext);
            _command.put("/bookmarks.bookmarksentry/add-entry", (Object)_params);
        }
        catch (JSONException _je) {
            throw new Exception(_je);
        }
        JSONArray _result = this.session.invoke(_command);
        if (_result == null) {
            return null;
        }
        return _result.getJSONObject(0);
    }

    public JSONArray getEntries(long groupId, long folderId, int start, int end) throws Exception {
        JSONObject _command = new JSONObject();
        try {
            JSONObject _params = new JSONObject();
            _params.put("groupId", groupId);
            _params.put("folderId", folderId);
            _params.put("start", start);
            _params.put("end", end);
            _command.put("/bookmarks.bookmarksentry/get-entries", (Object)_params);
        }
        catch (JSONException _je) {
            throw new Exception(_je);
        }
        JSONArray _result = this.session.invoke(_command);
        if (_result == null) {
            return null;
        }
        return _result.getJSONArray(0);
    }

    public JSONArray getEntries(long groupId, long folderId, int start, int end, JSONObjectWrapper orderByComparator) throws Exception {
        JSONObject _command = new JSONObject();
        try {
            JSONObject _params = new JSONObject();
            _params.put("groupId", groupId);
            _params.put("folderId", folderId);
            _params.put("start", start);
            _params.put("end", end);
            this.mangleWrapper(_params, "orderByComparator", "com.liferay.portal.kernel.util.OrderByComparator<com.liferay.bookmarks.model.BookmarksEntry>", orderByComparator);
            _command.put("/bookmarks.bookmarksentry/get-entries", (Object)_params);
        }
        catch (JSONException _je) {
            throw new Exception(_je);
        }
        JSONArray _result = this.session.invoke(_command);
        if (_result == null) {
            return null;
        }
        return _result.getJSONArray(0);
    }

    public JSONObject search(long groupId, long creatorUserId, int status, int start, int end) throws Exception {
        JSONObject _command = new JSONObject();
        try {
            JSONObject _params = new JSONObject();
            _params.put("groupId", groupId);
            _params.put("creatorUserId", creatorUserId);
            _params.put("status", status);
            _params.put("start", start);
            _params.put("end", end);
            _command.put("/bookmarks.bookmarksentry/search", (Object)_params);
        }
        catch (JSONException _je) {
            throw new Exception(_je);
        }
        JSONArray _result = this.session.invoke(_command);
        if (_result == null) {
            return null;
        }
        return _result.getJSONObject(0);
    }

    public JSONObject getEntry(long entryId) throws Exception {
        JSONObject _command = new JSONObject();
        try {
            JSONObject _params = new JSONObject();
            _params.put("entryId", entryId);
            _command.put("/bookmarks.bookmarksentry/get-entry", (Object)_params);
        }
        catch (JSONException _je) {
            throw new Exception(_je);
        }
        JSONArray _result = this.session.invoke(_command);
        if (_result == null) {
            return null;
        }
        return _result.getJSONObject(0);
    }

    public void deleteEntry(long entryId) throws Exception {
        JSONObject _command = new JSONObject();
        try {
            JSONObject _params = new JSONObject();
            _params.put("entryId", entryId);
            _command.put("/bookmarks.bookmarksentry/delete-entry", (Object)_params);
        }
        catch (JSONException _je) {
            throw new Exception(_je);
        }
        this.session.invoke(_command);
    }

    public JSONObject updateEntry(long entryId, long groupId, long folderId, String name, String url, String description, JSONObjectWrapper serviceContext) throws Exception {
        JSONObject _command = new JSONObject();
        try {
            JSONObject _params = new JSONObject();
            _params.put("entryId", entryId);
            _params.put("groupId", groupId);
            _params.put("folderId", folderId);
            _params.put("name", this.checkNull(name));
            _params.put("url", this.checkNull(url));
            _params.put("description", this.checkNull(description));
            this.mangleWrapper(_params, "serviceContext", "com.liferay.portal.kernel.service.ServiceContext", serviceContext);
            _command.put("/bookmarks.bookmarksentry/update-entry", (Object)_params);
        }
        catch (JSONException _je) {
            throw new Exception(_je);
        }
        JSONArray _result = this.session.invoke(_command);
        if (_result == null) {
            return null;
        }
        return _result.getJSONObject(0);
    }

    public JSONObject moveEntry(long entryId, long parentFolderId) throws Exception {
        JSONObject _command = new JSONObject();
        try {
            JSONObject _params = new JSONObject();
            _params.put("entryId", entryId);
            _params.put("parentFolderId", parentFolderId);
            _command.put("/bookmarks.bookmarksentry/move-entry", (Object)_params);
        }
        catch (JSONException _je) {
            throw new Exception(_je);
        }
        JSONArray _result = this.session.invoke(_command);
        if (_result == null) {
            return null;
        }
        return _result.getJSONObject(0);
    }

    public Integer getEntriesCount(long groupId, long folderId, int status) throws Exception {
        JSONObject _command = new JSONObject();
        try {
            JSONObject _params = new JSONObject();
            _params.put("groupId", groupId);
            _params.put("folderId", folderId);
            _params.put("status", status);
            _command.put("/bookmarks.bookmarksentry/get-entries-count", (Object)_params);
        }
        catch (JSONException _je) {
            throw new Exception(_je);
        }
        JSONArray _result = this.session.invoke(_command);
        if (_result == null) {
            return null;
        }
        return _result.getInt(0);
    }

    public Integer getEntriesCount(long groupId, long folderId) throws Exception {
        JSONObject _command = new JSONObject();
        try {
            JSONObject _params = new JSONObject();
            _params.put("groupId", groupId);
            _params.put("folderId", folderId);
            _command.put("/bookmarks.bookmarksentry/get-entries-count", (Object)_params);
        }
        catch (JSONException _je) {
            throw new Exception(_je);
        }
        JSONArray _result = this.session.invoke(_command);
        if (_result == null) {
            return null;
        }
        return _result.getInt(0);
    }

    public Integer getGroupEntriesCount(long groupId, long userId) throws Exception {
        JSONObject _command = new JSONObject();
        try {
            JSONObject _params = new JSONObject();
            _params.put("groupId", groupId);
            _params.put("userId", userId);
            _command.put("/bookmarks.bookmarksentry/get-group-entries-count", (Object)_params);
        }
        catch (JSONException _je) {
            throw new Exception(_je);
        }
        JSONArray _result = this.session.invoke(_command);
        if (_result == null) {
            return null;
        }
        return _result.getInt(0);
    }

    public Integer getGroupEntriesCount(long groupId, long userId, long rootFolderId) throws Exception {
        JSONObject _command = new JSONObject();
        try {
            JSONObject _params = new JSONObject();
            _params.put("groupId", groupId);
            _params.put("userId", userId);
            _params.put("rootFolderId", rootFolderId);
            _command.put("/bookmarks.bookmarksentry/get-group-entries-count", (Object)_params);
        }
        catch (JSONException _je) {
            throw new Exception(_je);
        }
        JSONArray _result = this.session.invoke(_command);
        if (_result == null) {
            return null;
        }
        return _result.getInt(0);
    }

    public Integer getGroupEntriesCount(long groupId) throws Exception {
        JSONObject _command = new JSONObject();
        try {
            JSONObject _params = new JSONObject();
            _params.put("groupId", groupId);
            _command.put("/bookmarks.bookmarksentry/get-group-entries-count", (Object)_params);
        }
        catch (JSONException _je) {
            throw new Exception(_je);
        }
        JSONArray _result = this.session.invoke(_command);
        if (_result == null) {
            return null;
        }
        return _result.getInt(0);
    }

    public JSONObject moveEntryToTrash(long entryId) throws Exception {
        JSONObject _command = new JSONObject();
        try {
            JSONObject _params = new JSONObject();
            _params.put("entryId", entryId);
            _command.put("/bookmarks.bookmarksentry/move-entry-to-trash", (Object)_params);
        }
        catch (JSONException _je) {
            throw new Exception(_je);
        }
        JSONArray _result = this.session.invoke(_command);
        if (_result == null) {
            return null;
        }
        return _result.getJSONObject(0);
    }

    public void restoreEntryFromTrash(long entryId) throws Exception {
        JSONObject _command = new JSONObject();
        try {
            JSONObject _params = new JSONObject();
            _params.put("entryId", entryId);
            _command.put("/bookmarks.bookmarksentry/restore-entry-from-trash", (Object)_params);
        }
        catch (JSONException _je) {
            throw new Exception(_je);
        }
        this.session.invoke(_command);
    }

    public JSONArray getGroupEntries(long groupId, int start, int end) throws Exception {
        JSONObject _command = new JSONObject();
        try {
            JSONObject _params = new JSONObject();
            _params.put("groupId", groupId);
            _params.put("start", start);
            _params.put("end", end);
            _command.put("/bookmarks.bookmarksentry/get-group-entries", (Object)_params);
        }
        catch (JSONException _je) {
            throw new Exception(_je);
        }
        JSONArray _result = this.session.invoke(_command);
        if (_result == null) {
            return null;
        }
        return _result.getJSONArray(0);
    }

    public JSONArray getGroupEntries(long groupId, long userId, int start, int end) throws Exception {
        JSONObject _command = new JSONObject();
        try {
            JSONObject _params = new JSONObject();
            _params.put("groupId", groupId);
            _params.put("userId", userId);
            _params.put("start", start);
            _params.put("end", end);
            _command.put("/bookmarks.bookmarksentry/get-group-entries", (Object)_params);
        }
        catch (JSONException _je) {
            throw new Exception(_je);
        }
        JSONArray _result = this.session.invoke(_command);
        if (_result == null) {
            return null;
        }
        return _result.getJSONArray(0);
    }

    public JSONArray getGroupEntries(long groupId, long userId, long rootFolderId, int start, int end) throws Exception {
        JSONObject _command = new JSONObject();
        try {
            JSONObject _params = new JSONObject();
            _params.put("groupId", groupId);
            _params.put("userId", userId);
            _params.put("rootFolderId", rootFolderId);
            _params.put("start", start);
            _params.put("end", end);
            _command.put("/bookmarks.bookmarksentry/get-group-entries", (Object)_params);
        }
        catch (JSONException _je) {
            throw new Exception(_je);
        }
        JSONArray _result = this.session.invoke(_command);
        if (_result == null) {
            return null;
        }
        return _result.getJSONArray(0);
    }

    public Integer getFoldersEntriesCount(long groupId, JSONArray folderIds) throws Exception {
        JSONObject _command = new JSONObject();
        try {
            JSONObject _params = new JSONObject();
            _params.put("groupId", groupId);
            _params.put("folderIds", this.checkNull(folderIds));
            _command.put("/bookmarks.bookmarksentry/get-folders-entries-count", (Object)_params);
        }
        catch (JSONException _je) {
            throw new Exception(_je);
        }
        JSONArray _result = this.session.invoke(_command);
        if (_result == null) {
            return null;
        }
        return _result.getInt(0);
    }

    public JSONObject openEntry(long entryId) throws Exception {
        JSONObject _command = new JSONObject();
        try {
            JSONObject _params = new JSONObject();
            _params.put("entryId", entryId);
            _command.put("/bookmarks.bookmarksentry/open-entry", (Object)_params);
        }
        catch (JSONException _je) {
            throw new Exception(_je);
        }
        JSONArray _result = this.session.invoke(_command);
        if (_result == null) {
            return null;
        }
        return _result.getJSONObject(0);
    }

    public JSONObject openEntry(JSONObjectWrapper entry) throws Exception {
        JSONObject _command = new JSONObject();
        try {
            JSONObject _params = new JSONObject();
            this.mangleWrapper(_params, "entry", "com.liferay.bookmarks.model.BookmarksEntry", entry);
            _command.put("/bookmarks.bookmarksentry/open-entry", (Object)_params);
        }
        catch (JSONException _je) {
            throw new Exception(_je);
        }
        JSONArray _result = this.session.invoke(_command);
        if (_result == null) {
            return null;
        }
        return _result.getJSONObject(0);
    }

    public JSONObject moveEntryFromTrash(long entryId, long parentFolderId) throws Exception {
        JSONObject _command = new JSONObject();
        try {
            JSONObject _params = new JSONObject();
            _params.put("entryId", entryId);
            _params.put("parentFolderId", parentFolderId);
            _command.put("/bookmarks.bookmarksentry/move-entry-from-trash", (Object)_params);
        }
        catch (JSONException _je) {
            throw new Exception(_je);
        }
        JSONArray _result = this.session.invoke(_command);
        if (_result == null) {
            return null;
        }
        return _result.getJSONObject(0);
    }

    public void subscribeEntry(long entryId) throws Exception {
        JSONObject _command = new JSONObject();
        try {
            JSONObject _params = new JSONObject();
            _params.put("entryId", entryId);
            _command.put("/bookmarks.bookmarksentry/subscribe-entry", (Object)_params);
        }
        catch (JSONException _je) {
            throw new Exception(_je);
        }
        this.session.invoke(_command);
    }

    public void unsubscribeEntry(long entryId) throws Exception {
        JSONObject _command = new JSONObject();
        try {
            JSONObject _params = new JSONObject();
            _params.put("entryId", entryId);
            _command.put("/bookmarks.bookmarksentry/unsubscribe-entry", (Object)_params);
        }
        catch (JSONException _je) {
            throw new Exception(_je);
        }
        this.session.invoke(_command);
    }
}

