/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.mobile.android.util;

import android.util.Log;
import com.liferay.mobile.android.http.HttpUtil;
import com.liferay.mobile.android.service.Session;
import com.liferay.mobile.android.util.PortalVersionUtil;
import com.liferay.mobile.android.util.Validator;
import java.io.Closeable;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.MessageDigest;
import org.apache.commons.codec.binary.Base64;
import org.apache.http.Header;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;

public class PortraitUtil {
    private static final String _CLASS_NAME = PortraitUtil.class.getName();

    public static String downloadPortrait(Session session, String portraitURL, OutputStream os) throws Exception {
        return PortraitUtil.downloadPortrait(session, portraitURL, os, null);
    }

    public static String downloadPortrait(Session session, String portraitURL, OutputStream os, String modifiedDate) throws Exception {
        String lastModified = null;
        InputStream is = null;
        try {
            HttpClient client;
            HttpResponse response;
            int status;
            HttpGet get = new HttpGet(portraitURL);
            if (Validator.isNotNull(modifiedDate)) {
                get.addHeader("If-Modified-Since", modifiedDate);
            }
            if ((status = (response = (client = HttpUtil.getClient(session)).execute((HttpUriRequest)get)).getStatusLine().getStatusCode()) == 200) {
                int count;
                is = response.getEntity().getContent();
                byte[] data = new byte[8192];
                while ((count = is.read(data)) != -1) {
                    os.write(data, 0, count);
                }
                Header header = response.getLastHeader("Last-Modified");
                lastModified = header.getValue();
            }
        }
        catch (Exception e) {
            Log.e((String)_CLASS_NAME, (String)"Couldn't download portrait", (Throwable)e);
            throw e;
        }
        finally {
            PortraitUtil.close(is);
            PortraitUtil.close(os);
        }
        return lastModified;
    }

    public static String downloadPortrait(Session session, String portraitURL, String filePath) throws Exception {
        return PortraitUtil.downloadPortrait(session, portraitURL, filePath, null);
    }

    public static String downloadPortrait(Session session, String portraitURL, String filePath, String modifiedDate) throws Exception {
        return PortraitUtil.downloadPortrait(session, portraitURL, new FileOutputStream(filePath), modifiedDate);
    }

    public static String getPortraitURL(Session session, boolean male, long portraitId) {
        return PortraitUtil.getPortraitURL(session, male, portraitId, null);
    }

    public static String getPortraitURL(Session session, boolean male, long portraitId, String uuid) {
        StringBuilder sb = new StringBuilder();
        sb.append(session.getServer());
        sb.append("/image/user_");
        if (male) {
            sb.append("male");
        } else {
            sb.append("female");
        }
        sb.append("_portrait?img_id=");
        sb.append(portraitId);
        int version = PortalVersionUtil.getPortalVersion(session);
        if (version > 6200) {
            PortraitUtil.appendToken(sb, uuid);
        }
        return sb.toString();
    }

    protected static void appendToken(StringBuilder sb, String uuid) {
        if (Validator.isNull(uuid)) {
            return;
        }
        try {
            MessageDigest digest = MessageDigest.getInstance("SHA-1");
            digest.update(uuid.getBytes());
            byte[] bytes = digest.digest();
            String token = Base64.encodeBase64String((byte[])bytes);
            sb.append("&img_id_token=");
            sb.append(HttpUtil.encodeURL(token));
        }
        catch (Exception e) {
            Log.e((String)_CLASS_NAME, (String)"Couldn't generate portrait image token", (Throwable)e);
        }
    }

    protected static void close(Closeable closeable) {
        if (closeable != null) {
            try {
                closeable.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

