/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.mobile.android.service;

import com.liferay.mobile.android.http.HttpUtil;
import com.liferay.mobile.android.service.Session;
import com.liferay.mobile.android.task.ServiceAsyncTask;
import com.liferay.mobile.android.task.UploadAsyncTask;
import com.liferay.mobile.android.task.callback.AsyncTaskCallback;
import com.liferay.mobile.android.util.Validator;
import org.apache.http.Header;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.impl.auth.BasicScheme;
import org.json.JSONArray;
import org.json.JSONObject;

public class SessionImpl
implements Session {
    public static final int DEFAULT_CONNECTION_TIMEOUT = 15000;
    protected AsyncTaskCallback callback;
    protected int connectionTimeout;
    protected String password;
    protected String server;
    protected String username;

    public SessionImpl(Session session) {
        this(session.getServer(), session.getUsername(), session.getPassword(), session.getConnectionTimeout(), session.getCallback());
    }

    public SessionImpl(String server) {
        this(server, null);
    }

    public SessionImpl(String server, AsyncTaskCallback callback) {
        this(server, null, null, callback);
    }

    public SessionImpl(String server, String username, String password) {
        this(server, username, password, 15000, null);
    }

    public SessionImpl(String server, String username, String password, AsyncTaskCallback callback) {
        this(server, username, password, 15000, callback);
    }

    public SessionImpl(String server, String username, String password, int connectionTimeout, AsyncTaskCallback callback) {
        this.server = server;
        this.username = username;
        this.password = password;
        this.connectionTimeout = connectionTimeout;
        this.callback = callback;
    }

    @Override
    public Header getAuthHeader() {
        String username = this.getUsername();
        if (Validator.isNull(this.getUsername()) || Validator.isNull(this.getPassword())) {
            return null;
        }
        UsernamePasswordCredentials credentials = new UsernamePasswordCredentials(username, this.getPassword());
        return BasicScheme.authenticate((Credentials)credentials, (String)"UTF-8", (boolean)false);
    }

    @Override
    public AsyncTaskCallback getCallback() {
        return this.callback;
    }

    @Override
    public int getConnectionTimeout() {
        return this.connectionTimeout;
    }

    @Override
    public String getPassword() {
        return this.password;
    }

    @Override
    public String getServer() {
        return this.server;
    }

    @Override
    public String getUsername() {
        return this.username;
    }

    @Override
    public Object invoke(JSONObject command) throws Exception {
        if (this.callback != null) {
            ServiceAsyncTask task = new ServiceAsyncTask(this, this.callback);
            task.execute(command);
            return null;
        }
        JSONArray json = HttpUtil.post((Session)this, command);
        return json.get(0);
    }

    @Override
    public void setCallback(AsyncTaskCallback callback) {
        this.callback = callback;
    }

    @Override
    public void setConnectionTimeout(int connectionTimeout) {
        this.connectionTimeout = connectionTimeout;
    }

    @Override
    public void setPassword(String password) {
        this.password = password;
    }

    @Override
    public void setServer(String server) {
        this.server = server;
    }

    @Override
    public void setUsername(String username) {
        this.username = username;
    }

    @Override
    public Object upload(JSONObject command) throws Exception {
        if (this.callback != null) {
            UploadAsyncTask task = new UploadAsyncTask(this, this.callback);
            task.execute(new JSONObject[]{command});
            return null;
        }
        return HttpUtil.upload(this, command, null);
    }
}

