/**
 * Copyright (c) 2000-2014 Liferay, Inc. All rights reserved.
 *
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
 * details.
 */

package com.liferay.mobile.android.v62.shoppingitem;

import com.liferay.mobile.android.service.BaseService;
import com.liferay.mobile.android.service.JSONObjectWrapper;
import com.liferay.mobile.android.service.Session;

import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

/**
 * @author Bruno Farache
 */
public class ShoppingItemService extends BaseService {

	public ShoppingItemService(Session session) {
		super(session);
	}

	public void addBookItems(long groupId, long categoryId, JSONArray isbns) throws Exception {
		JSONObject _command = new JSONObject();

		try {
			JSONObject _params = new JSONObject();

			_params.put("groupId", groupId);
			_params.put("categoryId", categoryId);
			_params.put("isbns", isbns);

			_command.put("/shoppingitem/add-book-items", _params);
		}
		catch (JSONException _je) {
			throw new Exception(_je);
		}

		session.invoke(_command);
	}

	public JSONObject addItem(long groupId, long categoryId, String sku, String name, String description, String properties, String fieldsQuantities, boolean requiresShipping, int stockQuantity, boolean featured, JSONObjectWrapper sale, boolean smallImage, String smallImageURL, JSONObjectWrapper smallFile, boolean mediumImage, String mediumImageURL, JSONObjectWrapper mediumFile, boolean largeImage, String largeImageURL, JSONObjectWrapper largeFile, JSONArray itemFields, JSONArray itemPrices, JSONObjectWrapper serviceContext) throws Exception {
		JSONObject _command = new JSONObject();

		try {
			JSONObject _params = new JSONObject();

			_params.put("groupId", groupId);
			_params.put("categoryId", categoryId);
			_params.put("sku", sku);
			_params.put("name", name);
			_params.put("description", description);
			_params.put("properties", properties);
			_params.put("fieldsQuantities", fieldsQuantities);
			_params.put("requiresShipping", requiresShipping);
			_params.put("stockQuantity", stockQuantity);
			_params.put("featured", featured);
			mangleWrapper(_params, "sale", "java.lang.Boolean", sale);
			_params.put("smallImage", smallImage);
			_params.put("smallImageURL", smallImageURL);
			mangleWrapper(_params, "smallFile", "java.io.File", smallFile);
			_params.put("mediumImage", mediumImage);
			_params.put("mediumImageURL", mediumImageURL);
			mangleWrapper(_params, "mediumFile", "java.io.File", mediumFile);
			_params.put("largeImage", largeImage);
			_params.put("largeImageURL", largeImageURL);
			mangleWrapper(_params, "largeFile", "java.io.File", largeFile);
			_params.put("itemFields", itemFields);
			_params.put("itemPrices", itemPrices);
			mangleWrapper(_params, "serviceContext", "com.liferay.portal.service.ServiceContext", serviceContext);

			_command.put("/shoppingitem/add-item", _params);
		}
		catch (JSONException _je) {
			throw new Exception(_je);
		}

		return (JSONObject)session.invoke(_command);
	}

	public void deleteItem(long itemId) throws Exception {
		JSONObject _command = new JSONObject();

		try {
			JSONObject _params = new JSONObject();

			_params.put("itemId", itemId);

			_command.put("/shoppingitem/delete-item", _params);
		}
		catch (JSONException _je) {
			throw new Exception(_je);
		}

		session.invoke(_command);
	}

	public Integer getCategoriesItemsCount(long groupId, JSONArray categoryIds) throws Exception {
		JSONObject _command = new JSONObject();

		try {
			JSONObject _params = new JSONObject();

			_params.put("groupId", groupId);
			_params.put("categoryIds", categoryIds);

			_command.put("/shoppingitem/get-categories-items-count", _params);
		}
		catch (JSONException _je) {
			throw new Exception(_je);
		}

		return (Integer)session.invoke(_command);
	}

	public JSONObject getItem(long itemId) throws Exception {
		JSONObject _command = new JSONObject();

		try {
			JSONObject _params = new JSONObject();

			_params.put("itemId", itemId);

			_command.put("/shoppingitem/get-item", _params);
		}
		catch (JSONException _je) {
			throw new Exception(_je);
		}

		return (JSONObject)session.invoke(_command);
	}

	public JSONArray getItems(long groupId, long categoryId) throws Exception {
		JSONObject _command = new JSONObject();

		try {
			JSONObject _params = new JSONObject();

			_params.put("groupId", groupId);
			_params.put("categoryId", categoryId);

			_command.put("/shoppingitem/get-items", _params);
		}
		catch (JSONException _je) {
			throw new Exception(_je);
		}

		return (JSONArray)session.invoke(_command);
	}

	public JSONArray getItems(long groupId, long categoryId, int start, int end, JSONObjectWrapper obc) throws Exception {
		JSONObject _command = new JSONObject();

		try {
			JSONObject _params = new JSONObject();

			_params.put("groupId", groupId);
			_params.put("categoryId", categoryId);
			_params.put("start", start);
			_params.put("end", end);
			mangleWrapper(_params, "obc", "com.liferay.portal.kernel.util.OrderByComparator", obc);

			_command.put("/shoppingitem/get-items", _params);
		}
		catch (JSONException _je) {
			throw new Exception(_je);
		}

		return (JSONArray)session.invoke(_command);
	}

	public Integer getItemsCount(long groupId, long categoryId) throws Exception {
		JSONObject _command = new JSONObject();

		try {
			JSONObject _params = new JSONObject();

			_params.put("groupId", groupId);
			_params.put("categoryId", categoryId);

			_command.put("/shoppingitem/get-items-count", _params);
		}
		catch (JSONException _je) {
			throw new Exception(_je);
		}

		return (Integer)session.invoke(_command);
	}

	public JSONArray getItemsPrevAndNext(long itemId, JSONObjectWrapper obc) throws Exception {
		JSONObject _command = new JSONObject();

		try {
			JSONObject _params = new JSONObject();

			_params.put("itemId", itemId);
			mangleWrapper(_params, "obc", "com.liferay.portal.kernel.util.OrderByComparator", obc);

			_command.put("/shoppingitem/get-items-prev-and-next", _params);
		}
		catch (JSONException _je) {
			throw new Exception(_je);
		}

		return (JSONArray)session.invoke(_command);
	}

	public JSONObject updateItem(long itemId, long groupId, long categoryId, String sku, String name, String description, String properties, String fieldsQuantities, boolean requiresShipping, int stockQuantity, boolean featured, JSONObjectWrapper sale, boolean smallImage, String smallImageURL, JSONObjectWrapper smallFile, boolean mediumImage, String mediumImageURL, JSONObjectWrapper mediumFile, boolean largeImage, String largeImageURL, JSONObjectWrapper largeFile, JSONArray itemFields, JSONArray itemPrices, JSONObjectWrapper serviceContext) throws Exception {
		JSONObject _command = new JSONObject();

		try {
			JSONObject _params = new JSONObject();

			_params.put("itemId", itemId);
			_params.put("groupId", groupId);
			_params.put("categoryId", categoryId);
			_params.put("sku", sku);
			_params.put("name", name);
			_params.put("description", description);
			_params.put("properties", properties);
			_params.put("fieldsQuantities", fieldsQuantities);
			_params.put("requiresShipping", requiresShipping);
			_params.put("stockQuantity", stockQuantity);
			_params.put("featured", featured);
			mangleWrapper(_params, "sale", "java.lang.Boolean", sale);
			_params.put("smallImage", smallImage);
			_params.put("smallImageURL", smallImageURL);
			mangleWrapper(_params, "smallFile", "java.io.File", smallFile);
			_params.put("mediumImage", mediumImage);
			_params.put("mediumImageURL", mediumImageURL);
			mangleWrapper(_params, "mediumFile", "java.io.File", mediumFile);
			_params.put("largeImage", largeImage);
			_params.put("largeImageURL", largeImageURL);
			mangleWrapper(_params, "largeFile", "java.io.File", largeFile);
			_params.put("itemFields", itemFields);
			_params.put("itemPrices", itemPrices);
			mangleWrapper(_params, "serviceContext", "com.liferay.portal.service.ServiceContext", serviceContext);

			_command.put("/shoppingitem/update-item", _params);
		}
		catch (JSONException _je) {
			throw new Exception(_je);
		}

		return (JSONObject)session.invoke(_command);
	}

}