/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.mobile.android.http;

import com.liferay.mobile.android.auth.Authentication;
import com.liferay.mobile.android.exception.RedirectException;
import com.liferay.mobile.android.exception.ServerException;
import com.liferay.mobile.android.http.entity.CountingHttpEntity;
import com.liferay.mobile.android.service.Session;
import com.liferay.mobile.android.task.UploadAsyncTask;
import com.liferay.mobile.android.util.Validator;
import java.io.IOException;
import java.net.URI;
import java.nio.charset.Charset;
import java.util.Iterator;
import org.apache.http.Consts;
import org.apache.http.HttpEntity;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.ProtocolException;
import org.apache.http.client.HttpClient;
import org.apache.http.client.RedirectStrategy;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.entity.mime.HttpMultipartMode;
import org.apache.http.entity.mime.MultipartEntityBuilder;
import org.apache.http.entity.mime.content.ContentBody;
import org.apache.http.entity.mime.content.InputStreamBody;
import org.apache.http.entity.mime.content.StringBody;
import org.apache.http.impl.client.DefaultRedirectStrategy;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.protocol.BasicHttpContext;
import org.apache.http.protocol.HttpContext;
import org.apache.http.util.EntityUtils;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class HttpUtil {
    public static final String IF_MODIFIED_SINCE = "If-Modified-Since";
    public static final String JSONWS_PATH_61 = "api/secure/jsonws";
    public static final String JSONWS_PATH_62 = "api/jsonws";
    public static final String LAST_MODIFIED = "Last-Modified";
    private static String _JSONWS_PATH = "api/jsonws";

    public static void checkStatusCode(HttpRequest request, HttpResponse response) throws ServerException {
        int status = response.getStatusLine().getStatusCode();
        if (status == 301 || status == 302 || status == 303 || status == 307) {
            throw new RedirectException(HttpUtil.getRedirectUrl(request, response));
        }
        if (status == 401) {
            throw new ServerException("Authentication failed.");
        }
        if (status != 200) {
            throw new ServerException("Request failed. Response code: " + status);
        }
    }

    public static HttpClient getClient(Session session) {
        return HttpUtil.getClientBuilder(session).build();
    }

    public static HttpClientBuilder getClientBuilder(Session session) {
        HttpClientBuilder clientBuilder = HttpClientBuilder.create();
        RequestConfig.Builder requestBuilder = RequestConfig.custom();
        int timeout = session.getConnectionTimeout();
        requestBuilder = requestBuilder.setConnectTimeout(timeout);
        requestBuilder = requestBuilder.setConnectionRequestTimeout(timeout);
        clientBuilder.setDefaultRequestConfig(requestBuilder.build());
        clientBuilder.setRedirectStrategy((RedirectStrategy)new DefaultRedirectStrategy(){

            protected boolean isRedirectable(String method) {
                return false;
            }
        });
        return clientBuilder;
    }

    public static HttpPost getHttpPost(Session session, String URL) throws Exception {
        HttpPost httpPost = new HttpPost(URL);
        HttpUtil.authenticate(session, (HttpRequest)httpPost);
        return httpPost;
    }

    public static String getResponseString(HttpResponse response) throws IOException {
        HttpEntity entity = response.getEntity();
        if (entity == null) {
            return null;
        }
        return EntityUtils.toString((HttpEntity)entity);
    }

    public static String getURL(Session session, String path) {
        StringBuilder sb = new StringBuilder();
        String server = session.getServer();
        sb.append(server);
        if (!server.endsWith("/")) {
            sb.append("/");
        }
        sb.append(_JSONWS_PATH);
        sb.append(path);
        return sb.toString();
    }

    public static JSONArray post(Session session, JSONArray commands) throws Exception {
        HttpClient client = HttpUtil.getClient(session);
        HttpPost request = HttpUtil.getHttpPost(session, HttpUtil.getURL(session, "/invoke"));
        request.setEntity((HttpEntity)new StringEntity(commands.toString(), "UTF-8"));
        HttpResponse response = client.execute((HttpUriRequest)request);
        String json = HttpUtil.getResponseString(response);
        HttpUtil.handleServerError((HttpRequest)request, response, json);
        return new JSONArray(json);
    }

    public static JSONArray post(Session session, JSONObject command) throws Exception {
        JSONArray commands = new JSONArray();
        commands.put((Object)command);
        return HttpUtil.post(session, commands);
    }

    public static void setJSONWSPath(String jsonwsPath) {
        _JSONWS_PATH = jsonwsPath;
    }

    public static JSONArray upload(Session session, JSONObject command, UploadAsyncTask task) throws Exception {
        String path = (String)command.keys().next();
        JSONObject parameters = command.getJSONObject(path);
        HttpClient client = HttpUtil.getClient(session);
        HttpPost request = HttpUtil.getHttpPost(session, HttpUtil.getURL(session, path));
        Object entity = HttpUtil.getMultipartEntity(parameters);
        if (task != null) {
            entity = new CountingHttpEntity((HttpEntity)entity, task);
        }
        request.setEntity(entity);
        HttpResponse response = client.execute((HttpUriRequest)request);
        String json = HttpUtil.getResponseString(response);
        HttpUtil.handleServerError((HttpRequest)request, response, json);
        return new JSONArray("[" + json + "]");
    }

    protected static void authenticate(Session session, HttpRequest request) throws Exception {
        Authentication authentication = session.getAuthentication();
        if (authentication != null) {
            authentication.authenticate(request);
        }
    }

    protected static HttpEntity getMultipartEntity(JSONObject parameters) throws Exception {
        MultipartEntityBuilder builder = MultipartEntityBuilder.create();
        builder.setMode(HttpMultipartMode.BROWSER_COMPATIBLE);
        ContentType contentType = ContentType.create((String)"text/plain", (Charset)Consts.UTF_8);
        Iterator it = parameters.keys();
        while (it.hasNext()) {
            String key = (String)it.next();
            Object value = parameters.get(key);
            Object contentBody = value instanceof InputStreamBody ? (InputStreamBody)value : new StringBody(value.toString(), contentType);
            builder.addPart(key, (ContentBody)contentBody);
        }
        return builder.build();
    }

    protected static String getRedirectUrl(HttpRequest request, HttpResponse response) throws ServerException {
        try {
            DefaultRedirectStrategy redirect = new DefaultRedirectStrategy();
            BasicHttpContext context = new BasicHttpContext();
            URI uri = redirect.getLocationURI(request, response, (HttpContext)context);
            String url = uri.toString();
            if (url.endsWith("/")) {
                url = url.substring(0, url.length() - 1);
            }
            return url;
        }
        catch (ProtocolException pe) {
            throw new ServerException(pe);
        }
    }

    protected static void handlePortalException(String json) throws ServerException {
        try {
            JSONObject jsonObj;
            if (HttpUtil.isJSONObject(json) && (jsonObj = new JSONObject(json)).has("exception")) {
                String message = jsonObj.getString("exception");
                String detail = jsonObj.optString("message", null);
                JSONObject error = jsonObj.optJSONObject("error");
                if (error != null) {
                    message = error.getString("type");
                    detail = error.getString("message");
                }
                throw new ServerException(message, detail);
            }
        }
        catch (JSONException je) {
            throw new ServerException(je);
        }
    }

    protected static void handleServerError(HttpRequest request, HttpResponse response, String json) throws ServerException {
        HttpUtil.checkStatusCode(request, response);
        HttpUtil.handlePortalException(json);
    }

    protected static boolean isJSONObject(String json) {
        return Validator.isNotNull(json) && json.startsWith("{");
    }
}

