/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.mobile.android.util.download;

import android.net.Uri;
import com.liferay.mobile.android.auth.Authentication;
import com.liferay.mobile.android.auth.basic.BasicAuthentication;
import com.liferay.mobile.android.http.HttpUtil;
import com.liferay.mobile.android.service.Session;
import com.liferay.mobile.android.util.download.DownloadProgressCallback;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.HttpClientBuilder;

public class DownloadUtil {
    private static final String ALLOWED_URI_CHARS = "@#&=*+-_.,:!?()/~'%";

    public static void download(Session session, String URL2, OutputStream os, DownloadProgressCallback callback) throws Exception {
        int count;
        HttpClientBuilder clientBuilder = HttpUtil.getClientBuilder(session);
        BasicCredentialsProvider provider = new BasicCredentialsProvider();
        provider.setCredentials(new AuthScope(AuthScope.ANY_HOST, -1), (Credentials)DownloadUtil.getCredentials(session));
        clientBuilder.setDefaultCredentialsProvider((CredentialsProvider)provider);
        HttpGet request = new HttpGet(URL2);
        CloseableHttpResponse response = clientBuilder.build().execute((HttpUriRequest)request);
        HttpUtil.checkStatusCode((HttpRequest)request, (HttpResponse)response);
        InputStream is = response.getEntity().getContent();
        int totalBytes = 0;
        byte[] data = new byte[8192];
        while ((count = is.read(data)) != -1) {
            os.write(data, 0, count);
            if (callback == null) continue;
            callback.onProgress(totalBytes += count);
        }
    }

    public static void downloadFile(Session session, String groupFriendlyURL, String folderPath, String fileTitle, OutputStream os, DownloadProgressCallback callback) throws Exception {
        String URL2 = DownloadUtil.getDownloadURL(session, groupFriendlyURL, folderPath, fileTitle);
        DownloadUtil.download(session, URL2, os, callback);
    }

    public static String getDownloadURL(Session session, String groupFriendlyURL, String folderPath, String fileTitle) throws Exception {
        StringBuilder sb = new StringBuilder();
        sb.append(session.getServer());
        sb.append("/webdav");
        sb.append(groupFriendlyURL);
        sb.append("/document_library");
        StringBuilder webdavPath = new StringBuilder();
        webdavPath.append(folderPath);
        webdavPath.append("/");
        webdavPath.append(fileTitle);
        sb.append(Uri.encode((String)webdavPath.toString(), (String)ALLOWED_URI_CHARS));
        return sb.toString();
    }

    protected static UsernamePasswordCredentials getCredentials(Session session) throws Exception {
        Authentication auth = session.getAuthentication();
        if (auth == null) {
            throw new Exception("Session's authentication can't be null");
        }
        if (!(auth instanceof BasicAuthentication)) {
            throw new Exception("Can't sign in if authentication implementation is notBasicAuthentication");
        }
        String username = ((BasicAuthentication)auth).getUsername();
        String password = ((BasicAuthentication)auth).getPassword();
        return new UsernamePasswordCredentials(username, password);
    }
}

