/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.mobile.android.auth;

import com.liferay.mobile.android.auth.Authentication;
import com.liferay.mobile.android.auth.SignInMethod;
import com.liferay.mobile.android.auth.basic.BasicAuthentication;
import com.liferay.mobile.android.service.Session;
import com.liferay.mobile.android.service.SessionImpl;
import com.liferay.mobile.android.task.callback.typed.JSONArrayAsyncTaskCallback;
import com.liferay.mobile.android.task.callback.typed.JSONObjectAsyncTaskCallback;
import com.liferay.mobile.android.v62.group.GroupService;
import com.liferay.mobile.android.v62.user.UserService;
import org.json.JSONArray;
import org.json.JSONObject;

public class SignIn {
    public static void signIn(final Session session, final JSONObjectAsyncTaskCallback callback, final SignInMethod method) {
        GroupService groupService = new GroupService(session);
        session.setCallback(new JSONArrayAsyncTaskCallback(){

            @Override
            public void onSuccess(JSONArray sites) {
                int length = sites.length();
                if (length == 0) {
                    this.onFailure(new Exception("User doesn't belong to any site"));
                }
                try {
                    JSONObject site = sites.getJSONObject(0);
                    long companyId = site.getLong("companyId");
                    SessionImpl userSession = new SessionImpl(session);
                    userSession.setCallback(callback);
                    UserService userService = new UserService(userSession);
                    String username = SignIn.getUsername(session);
                    if (method == SignInMethod.EMAIL) {
                        userService.getUserByEmailAddress(companyId, username);
                    } else if (method == SignInMethod.USER_ID) {
                        userService.getUserById(Long.parseLong(username));
                    } else {
                        userService.getUserByScreenName(companyId, username);
                    }
                }
                catch (Exception e) {
                    this.onFailure(e);
                }
            }

            @Override
            public void onFailure(Exception e) {
                callback.onFailure(e);
            }
        });
        try {
            groupService.getUserSites();
        }
        catch (Exception e) {
            callback.onFailure(e);
        }
    }

    public static void signIn(Session session, JSONObjectAsyncTaskCallback callback) {
        try {
            String username = SignIn.getUsername(session);
            SignInMethod method = SignInMethod.fromUsername(username);
            SignIn.signIn(session, callback, method);
        }
        catch (Exception e) {
            callback.onFailure(e);
        }
    }

    protected static String getUsername(Session session) throws Exception {
        Authentication auth = session.getAuthentication();
        if (auth == null) {
            throw new Exception("Session's authentication can't be null");
        }
        if (!(auth instanceof BasicAuthentication)) {
            throw new Exception("Can't sign in if authentication implementation is notBasicAuthentication");
        }
        return ((BasicAuthentication)auth).getUsername();
    }
}

