/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.mobile.fcm;

import com.liferay.mobile.fcm.To;
import com.liferay.mobile.fcm.Topic;
import com.liferay.mobile.fcm.exception.ExceededNumberOfOperators;

public class Condition
implements To {
    protected To left;
    protected boolean parentheses;
    protected Operator operator;
    protected To right;

    public Condition(To left, Operator operator, To right) throws ExceededNumberOfOperators {
        this.left = left;
        this.operator = operator;
        this.right = right;
        this.countNumberOfTopics(this);
    }

    public Condition(To to) {
        this.left = to;
    }

    public Condition and(To to) throws ExceededNumberOfOperators {
        if (this.operator != null) {
            this.left = new Condition(this.left, this.operator, this.right);
        }
        this.right = to;
        this.operator = Operator.AND;
        this.countNumberOfTopics(this);
        return this;
    }

    @Override
    public String condition() {
        StringBuilder sb = new StringBuilder();
        if (this.parentheses) {
            sb.append("(");
        }
        sb.append(this.left.condition());
        sb.append(" ");
        sb.append(this.operator.value);
        sb.append(" ");
        sb.append(this.right.condition());
        if (this.parentheses) {
            sb.append(")");
        }
        return sb.toString();
    }

    public Condition or(To to) throws ExceededNumberOfOperators {
        if (this.operator != null) {
            this.left = new Condition(this.left, this.operator, this.right);
        }
        this.right = to;
        this.operator = Operator.OR;
        this.countNumberOfTopics(this);
        return this;
    }

    public Condition parentheses() {
        this.parentheses = true;
        return this;
    }

    protected int countNumberOfTopics(To to) throws ExceededNumberOfOperators {
        if (to instanceof Topic) {
            return 1;
        }
        Condition condition = (Condition)to;
        int sum = this.countNumberOfTopics(condition.left) + this.countNumberOfTopics(condition.right);
        if (sum > 3) {
            throw new ExceededNumberOfOperators(this);
        }
        return sum;
    }

    public static enum Operator {
        AND("&&"),
        OR("||");

        final String value;

        private Operator(String value) {
            this.value = value;
        }
    }
}

