/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.maven.plugins.util;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.commons.lang.StringUtils;

public class ContextReplace
implements Cloneable {
    private Map<String, String> _context = new LinkedHashMap<String, String>();
    private String[] _keys = new String[0];
    private String[] _values = new String[0];

    public ContextReplace() {
        this(null);
    }

    public ContextReplace(Map<String, String> context) {
        if (context != null) {
            this._context.putAll(context);
            this._updateArrays();
        }
    }

    public void addValue(String key, String value) {
        if (key != null && value != null) {
            this._context.put(key, value);
            this._updateArrays();
        }
    }

    public Object clone() {
        return new ContextReplace(this._context);
    }

    public String replace(String text) {
        if (text == null) {
            return null;
        }
        if (this._keys.length == 0) {
            return text;
        }
        return this._replace(text, this._keys, this._values);
    }

    private String _replace(String s, String[] oldSubs, String[] newSubs) {
        if (s == null || oldSubs == null || newSubs == null) {
            return null;
        }
        if (oldSubs.length != newSubs.length) {
            return s;
        }
        for (int i = 0; i < oldSubs.length; ++i) {
            s = StringUtils.replace((String)s, (String)oldSubs[i], (String)newSubs[i]);
        }
        return s;
    }

    private void _updateArrays() {
        ArrayList<String> keys = new ArrayList<String>();
        ArrayList<String> values = new ArrayList<String>();
        for (Map.Entry<String, String> entry : this._context.entrySet()) {
            String entryKey = entry.getKey();
            String entryValue = entry.getValue();
            keys.add("${" + entryKey + "}");
            values.add(entryValue);
        }
        this._keys = keys.toArray(new String[keys.size()]);
        this._values = values.toArray(new String[values.size()]);
    }
}

