/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.maven.plugins;

import com.liferay.maven.plugins.AbstractLiferayMojo;
import com.liferay.maven.plugins.util.CopyTask;
import com.liferay.maven.plugins.util.FileUtil;
import java.io.File;
import org.apache.maven.model.Build;
import org.apache.maven.plugin.MojoExecutionException;

public class PluginDirectDeployerMojo
extends AbstractLiferayMojo {
    private File appServerDeployDir;
    private String appServerType;
    private String baseDir;
    private boolean customPortletXml;
    private boolean dependencyAddClassifier;
    private boolean dependencyAddVersion;
    private boolean dependencyAddVersionAndClassifier;
    private boolean dependencyCopyTransitive;
    private File deployDir;
    private boolean fullDeploy;
    private String jbossPrefix;
    private String pluginName;
    private boolean unpackWar;
    private String warFileName;

    protected void deployExt() throws Exception {
        File sourceFile;
        String artifactId = this.project.getArtifactId();
        Build build = this.project.getBuild();
        if (artifactId.endsWith("ext-lib-global")) {
            this.copyLibraryDependencies(this.appServerLibGlobalDir, this.project.getArtifact(), this.dependencyAddVersion, this.dependencyAddClassifier, this.dependencyCopyTransitive);
        }
        if (artifactId.endsWith("ext-lib-portal")) {
            this.copyLibraryDependencies(this.appServerLibPortalDir, this.project.getArtifact(), this.dependencyAddVersion, this.dependencyAddClassifier, this.dependencyCopyTransitive);
        }
        if (artifactId.endsWith("ext-service")) {
            sourceFile = new File(build.getDirectory(), build.getFinalName() + "." + this.project.getPackaging());
            this.deployExtService(sourceFile);
            this.copyLibraryDependencies(this.appServerLibGlobalDir, this.project.getArtifact(), this.dependencyAddVersion, this.dependencyAddClassifier, this.dependencyCopyTransitive);
        }
        if (artifactId.endsWith("ext-impl")) {
            sourceFile = new File(build.getDirectory(), build.getFinalName() + "." + this.project.getPackaging());
            File sourceDir = new File(build.getOutputDirectory());
            this.deployExtImpl(sourceDir, sourceFile);
            this.copyLibraryDependencies(this.appServerLibPortalDir, this.project.getArtifact(), this.dependencyAddVersion, this.dependencyAddClassifier, this.dependencyCopyTransitive);
        }
        if (artifactId.endsWith("ext-util-bridges") || artifactId.endsWith("ext-util-java") || artifactId.endsWith("ext-util-taglib")) {
            sourceFile = new File(build.getDirectory(), build.getFinalName() + "." + this.project.getPackaging());
            String utilName = "util-" + artifactId.substring(artifactId.lastIndexOf(45));
            this.deployExtUtil(sourceFile, utilName);
            this.copyLibraryDependencies(this.appServerLibPortalDir, this.project.getArtifact(), this.dependencyAddVersion, this.dependencyAddClassifier, this.dependencyCopyTransitive);
        }
        if (artifactId.endsWith("ext-web")) {
            File sourceDir = new File(build.getDirectory(), build.getFinalName());
            this.copyLibraryDependencies(this.appServerLibPortalDir, this.project.getArtifact(), this.dependencyAddVersion, this.dependencyAddClassifier, this.dependencyCopyTransitive);
            this.deployExtWeb(sourceDir);
        }
        String packaging = this.project.getPackaging();
        if (artifactId.endsWith("-ext") && packaging.equals("war")) {
            File buildDir = new File(build.getDirectory(), build.getFinalName());
            if (this.fullDeploy) {
                File extImplClassesDir = new File(buildDir, "WEB-INF/ext-impl/classes");
                File extImplJarFile = new File(buildDir, "WEB-INF/ext-impl/ext-impl.jar");
                this.deployExtImpl(extImplClassesDir, extImplJarFile);
                File extLibDir = new File(buildDir, "WEB-INF/ext-lib");
                this.deployExtLib(extLibDir);
                File extServiceJarFile = new File(buildDir, "WEB-INF/ext-service/ext-service.jar");
                this.deployExtService(extServiceJarFile);
                File extUtilBridgesJarFile = new File(buildDir, "WEB-INF/ext-util-bridges/ext-util-bridges.jar");
                this.deployExtUtil(extUtilBridgesJarFile, "util-bridges");
                File extUtilJavaJarFile = new File(buildDir, "WEB-INF/ext-util-java/ext-util-java.jar");
                this.deployExtUtil(extUtilJavaJarFile, "util-java");
                File extUtilTaglibJarFile = new File(buildDir, "WEB-INF/ext-util-taglib/ext-util-taglib.jar");
                this.deployExtUtil(extUtilTaglibJarFile, "util-taglib");
                File extWebDocrootDir = new File(buildDir, "WEB-INF/ext-web/docroot");
                this.deployExtWeb(extWebDocrootDir);
            }
            File sourceFile2 = new File(buildDir, "WEB-INF/ext-" + this.pluginName + ".xml");
            CopyTask.copyFile(sourceFile2, new File(this.appServerPortalDir, "WEB-INF"), true, true);
        }
    }

    protected void deployExtImpl(File extImplClassesDir, File extImplJarFile) {
        CopyTask.copyFile(extImplJarFile, this.appServerLibPortalDir, "ext-" + this.pluginName + "-impl.jar", null, true, true);
        CopyTask.copyDirectory(extImplClassesDir, this.appServerClassesPortalDir, null, null);
    }

    protected void deployExtLib(File extLibDir) {
        File extLibGlobalDir = new File(extLibDir, "global");
        CopyTask.copyDirectory(extLibGlobalDir, this.appServerLibGlobalDir, "*.jar", null, true, true);
        File extLibPortalDir = new File(extLibDir, "portal");
        CopyTask.copyDirectory(extLibPortalDir, this.appServerLibPortalDir, "*.jar", null, true, true);
    }

    protected void deployExtService(File extServiceJarFile) {
        CopyTask.copyFile(extServiceJarFile, this.appServerLibGlobalDir, "ext-" + this.pluginName + "-service.jar", null, true, true);
    }

    protected void deployExtUtil(File extUtilFile, String utilName) {
        String fileName = "ext-" + this.pluginName + "-" + utilName + ".jar";
        CopyTask.copyFile(extUtilFile, this.appServerLibPortalDir, fileName, null, true, true);
        File deployDependenciesDir = new File(this.appServerClassesPortalDir, "com/liferay/portal/deploy/dependencies");
        if (!deployDependenciesDir.exists()) {
            deployDependenciesDir.mkdirs();
        }
        CopyTask.copyFile(extUtilFile, deployDependenciesDir, fileName, null, true, true);
    }

    protected void deployExtWeb(File extWebDocrootDir) throws Exception {
        CopyTask.copyDirectory(extWebDocrootDir, this.appServerPortalDir, null, "WEB-INF/web.xml", true, true);
        File originalWebXml = new File(this.appServerPortalDir, "WEB-INF/web.xml");
        File mergedWebXml = new File(this.appServerPortalDir, "WEB-INF/web.xml.merged");
        String[] args = new String[]{originalWebXml.getAbsolutePath(), new File(extWebDocrootDir, "/WEB-INF/web.xml").getAbsolutePath(), mergedWebXml.getAbsolutePath()};
        this.executeTool("com.liferay.portal.tools.WebXMLBuilder", this.getProjectClassLoader(), args);
        FileUtil.move(mergedWebXml, originalWebXml);
    }

    protected void deployHook() throws Exception {
        this.executeTool("com.liferay.portal.tools.deploy.HookDeployer", this.getProjectClassLoader(), this.getRequiredPortalJars());
    }

    protected void deployLayoutTemplate() throws Exception {
        this.executeTool("com.liferay.portal.tools.deploy.LayoutTemplateDeployer", this.getProjectClassLoader(), this.getRequiredPortalJars());
    }

    protected void deployPortlet() throws Exception {
        String tldPath = this.appServerTldPortalDir.getAbsolutePath();
        System.setProperty("deployer.aui.taglib.dtd", tldPath + "/aui.tld");
        System.setProperty("deployer.custom.portlet.xml", String.valueOf(this.customPortletXml));
        System.setProperty("deployer.portlet.taglib.dtd", tldPath + "/liferay-portlet.tld");
        System.setProperty("deployer.portlet-ext.taglib.dtd", tldPath + "/liferay-portlet-ext.tld");
        System.setProperty("deployer.security.taglib.dtd", tldPath + "/liferay-security.tld");
        System.setProperty("deployer.theme.taglib.dtd", tldPath + "/liferay-theme.tld");
        System.setProperty("deployer.ui.taglib.dtd", tldPath + "/liferay-ui.tld");
        System.setProperty("deployer.util.taglib.dtd", tldPath + "/liferay-util.tld");
        this.executeTool("com.liferay.portal.tools.deploy.PortletDeployer", this.getProjectClassLoader(), this.getRequiredPortalJars());
    }

    protected void deployTheme() throws Exception {
        String tldPath = this.appServerTldPortalDir.getAbsolutePath();
        System.setProperty("deployer.theme.taglib.dtd", tldPath + "/liferay-theme.tld");
        System.setProperty("deployer.util.taglib.dtd", tldPath + "/liferay-util.tld");
        this.executeTool("com.liferay.portal.tools.deploy.ThemeDeployer", this.getProjectClassLoader(), this.getRequiredPortalJars());
    }

    protected void deployWeb() throws Exception {
        this.executeTool("com.liferay.portal.tools.deploy.WebDeployer", this.getProjectClassLoader(), this.getRequiredPortalJars());
    }

    protected void doExecute() throws Exception {
        if (this.appServerLibGlobalDir == null && this.pluginType.equals("ext")) {
            throw new MojoExecutionException("The parameter appServerLibGlobalDir is required");
        }
        if (this.appServerLibPortalDir == null) {
            throw new MojoExecutionException("The parameter appServerLibPortalDir is required");
        }
        this.getLog().info((CharSequence)("Directly deploying " + this.project.getArtifactId()));
        this.getLog().debug((CharSequence)("appServerType: " + this.appServerType));
        this.getLog().debug((CharSequence)("baseDir: " + this.baseDir));
        this.getLog().debug((CharSequence)("deployDir: " + this.appServerDeployDir.getAbsolutePath()));
        this.getLog().debug((CharSequence)("jbossPrefix: " + this.jbossPrefix));
        this.getLog().debug((CharSequence)("pluginType: " + this.pluginType));
        this.getLog().debug((CharSequence)("unpackWar: " + this.unpackWar));
        System.setProperty("deployer.app.server.type", this.appServerType);
        System.setProperty("deployer.base.dir", this.baseDir);
        System.setProperty("deployer.dest.dir", this.appServerDeployDir.getAbsolutePath());
        System.setProperty("deployer.file.pattern", this.warFileName);
        System.setProperty("deployer.unpack.war", String.valueOf(this.unpackWar));
        if (this.dependencyAddVersionAndClassifier) {
            this.dependencyAddVersion = true;
            this.dependencyAddClassifier = true;
        }
        if (this.pluginType.equals("ext")) {
            this.deployExt();
        } else if (this.pluginType.equals("hook")) {
            this.deployHook();
        } else if (this.pluginType.equals("layouttpl")) {
            this.deployLayoutTemplate();
        } else if (this.pluginType.equals("portlet")) {
            this.deployPortlet();
        } else if (this.pluginType.equals("theme")) {
            this.deployTheme();
        } else if (this.pluginType.equals("web")) {
            this.deployWeb();
        }
    }

    protected String[] getRequiredPortalJars() {
        String path = this.appServerLibPortalDir.getAbsolutePath();
        return new String[]{path + "/util-bridges.jar", path + "/util-java.jar", path + "/util-taglib.jar"};
    }

    protected boolean isLiferayProject() {
        String artifactId = this.project.getArtifactId();
        if (this.pluginType.equals("ext") && (artifactId.endsWith("ext-lib-global") || artifactId.endsWith("ext-lib-portal"))) {
            return true;
        }
        return super.isLiferayProject();
    }
}

