/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.maven.plugins;

import com.liferay.maven.plugins.AbstractLiferayMojo;
import com.liferay.maven.plugins.util.CopyTask;
import com.liferay.maven.plugins.util.FileUtil;
import com.liferay.maven.plugins.util.GetterUtil;
import com.liferay.maven.plugins.util.SAXReaderUtil;
import com.liferay.maven.plugins.util.Validator;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URI;
import java.net.URL;
import java.net.URLClassLoader;
import java.security.Permission;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.io.FileUtils;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.factory.ArtifactFactory;
import org.apache.maven.artifact.handler.ArtifactHandler;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.resolver.ArtifactResolver;
import org.apache.maven.execution.MavenExecutionRequest;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.Dependency;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.DefaultProjectBuildingRequest;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.ProjectBuilder;
import org.apache.maven.project.ProjectBuildingRequest;
import org.apache.maven.project.ProjectBuildingResult;
import org.codehaus.plexus.archiver.UnArchiver;
import org.codehaus.plexus.archiver.manager.ArchiverManager;
import org.xml.sax.EntityResolver;

public abstract class AbstractToolsLiferayMojo
extends AbstractLiferayMojo {
    public static final float PORTAL_VERSION_6_1 = 6.1f;
    public static final float PORTAL_VERSION_6_2 = 6.2f;
    protected static boolean initialized;
    protected File appServerClassesPortalDir;
    protected File appServerLibGlobalDir;
    protected File appServerLibPortalDir;
    protected File appServerPortalDir;
    protected File appServerTldPortalDir;
    protected ArchiverManager archiverManager;
    protected ArtifactFactory artifactFactory;
    protected ArtifactResolver artifactResolver;
    protected ArtifactRepository localArtifactRepository;
    protected String pluginType;
    protected ProjectBuilder projectBuilder;
    protected List remoteArtifactRepositories;
    protected MavenSession session;
    protected File workDir;
    private static Pattern _majorVersionPattern;

    public void execute() throws MojoExecutionException {
        try {
            if (!this.isLiferayProject()) {
                return;
            }
            if (this.getPortalMajorVersion() < 6.1f) {
                throw new MojoExecutionException("Liferay versions below 6.1.0 are not supported");
            }
            this.initPortalProperties();
            this.initUtils();
            this.doExecute();
        }
        catch (Throwable t) {
            if (t instanceof MojoExecutionException) {
                throw (MojoExecutionException)t;
            }
            throw new MojoExecutionException(t.getMessage(), t);
        }
    }

    protected void addDependencyToClassPath(List<String> classPath, Dependency dependency) throws Exception {
        URI uri = this.resolveArtifactFileURI(dependency);
        URL url = uri.toURL();
        classPath.add(url.toString());
    }

    protected void copyLibraryDependencies(File libDir, Artifact artifact) throws Exception {
        this.copyLibraryDependencies(libDir, artifact, false, false, false);
    }

    protected void copyLibraryDependencies(File libDir, Artifact artifact, boolean dependencyAddVersion, boolean dependencyAddClassifier, boolean copyTransitive) throws Exception {
        MavenProject mavenProject = this.resolveProject(artifact);
        List dependencies = mavenProject.getDependencies();
        for (Dependency dependency : dependencies) {
            String type;
            String scope = dependency.getScope();
            if (Validator.isNotNull(scope) && (scope.equalsIgnoreCase("provided") || scope.equalsIgnoreCase("test")) || (type = dependency.getType()).equalsIgnoreCase("pom")) continue;
            Artifact libArtifact = this.resolveArtifact(dependency);
            String libJarFileName = libArtifact.getArtifactId();
            if (dependencyAddVersion && Validator.isNotNull(libArtifact.getVersion())) {
                libJarFileName = libJarFileName + "-" + libArtifact.getVersion();
            }
            if (dependencyAddClassifier && Validator.isNotNull(libArtifact.getClassifier())) {
                libJarFileName = libJarFileName + "-" + libArtifact.getClassifier();
            }
            File libArtifactFile = libArtifact.getFile();
            libJarFileName = libJarFileName + "." + FileUtil.getExtension(libArtifactFile.getName());
            CopyTask.copyFile(libArtifactFile, libDir, libJarFileName, null, true, true);
            if (!copyTransitive) continue;
            this.copyLibraryDependencies(libDir, libArtifact, dependencyAddVersion, dependencyAddClassifier, copyTransitive);
        }
    }

    protected Dependency createDependency(String groupId, String artifactId, String version, String classifier, String type) {
        Dependency dependency = new Dependency();
        dependency.setArtifactId(artifactId);
        dependency.setClassifier(classifier);
        dependency.setGroupId(groupId);
        dependency.setType(type);
        dependency.setVersion(version);
        return dependency;
    }

    protected abstract void doExecute() throws Exception;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void executeTool(String toolClassName, ClassLoader classLoader, String[] args) throws Exception {
        block6: {
            Thread currentThread = Thread.currentThread();
            ClassLoader contextClassLoader = currentThread.getContextClassLoader();
            currentThread.setContextClassLoader(classLoader);
            SecurityManager currentSecurityManager = System.getSecurityManager();
            SecurityManager securityManager = new SecurityManager(){

                @Override
                public void checkPermission(Permission permission) {
                }

                @Override
                public void checkExit(int status) {
                    throw new SecurityException();
                }
            };
            System.setSecurityManager(securityManager);
            try {
                System.setProperty("external-properties", "com/liferay/portal/tools/dependencies/portal-tools.properties");
                System.setProperty("org.apache.commons.logging.Log", "org.apache.commons.logging.impl.Log4JLogger");
                Class<?> clazz = classLoader.loadClass(toolClassName);
                Method method = clazz.getMethod("main", String[].class);
                method.invoke(null, new Object[]{args});
            }
            catch (InvocationTargetException ite) {
                if (ite.getCause() instanceof SecurityException) {
                    break block6;
                }
                throw ite;
            }
            finally {
                currentThread.setContextClassLoader(contextClassLoader);
                System.clearProperty("org.apache.commons.logging.Log");
                System.setSecurityManager(currentSecurityManager);
            }
        }
    }

    protected float getPortalMajorVersion() {
        float majorVersion = 0.0f;
        Matcher matcher = _majorVersionPattern.matcher(this.liferayVersion);
        if (matcher.find()) {
            majorVersion = GetterUtil.getFloat(matcher.group(1));
        }
        return majorVersion;
    }

    protected ClassLoader getProjectClassLoader() throws Exception {
        return this.toClassLoader(this.getProjectClassPath());
    }

    protected List<String> getProjectClassPath() throws Exception {
        ArrayList<String> projectClassPath = new ArrayList<String>();
        projectClassPath.addAll(this.getToolsClassPath());
        ArrayList<MavenProject> classPathMavenProjects = new ArrayList<MavenProject>();
        classPathMavenProjects.add(this.project);
        for (Object object : this.project.getDependencyArtifacts()) {
            MavenProject dependencyMavenProject;
            Artifact artifact = (Artifact)object;
            ArtifactHandler artifactHandler = artifact.getArtifactHandler();
            if (!artifactHandler.isAddedToClasspath() || (dependencyMavenProject = this.resolveProject(artifact)) == null) continue;
            this.getLog().debug((CharSequence)("Resolved dependency project " + dependencyMavenProject));
            List compileSourceRoots = dependencyMavenProject.getCompileSourceRoots();
            if (compileSourceRoots.isEmpty()) continue;
            this.getLog().debug((CharSequence)("Adding project to class path " + dependencyMavenProject));
            classPathMavenProjects.add(dependencyMavenProject);
        }
        for (MavenProject classPathMavenProject : classPathMavenProjects) {
            for (Object object : classPathMavenProject.getCompileClasspathElements()) {
                String path = (String)object;
                this.getLog().debug((CharSequence)("Class path element " + path));
                File file = new File(path);
                URI uri = file.toURI();
                URL url = uri.toURL();
                projectClassPath.add(url.toString());
            }
        }
        this.getLog().debug((CharSequence)"Project class path:");
        for (String path : projectClassPath) {
            this.getLog().debug((CharSequence)("\t" + path));
        }
        return projectClassPath;
    }

    protected ClassLoader getToolsClassLoader() throws Exception {
        return this.toClassLoader(this.getToolsClassPath());
    }

    protected ClassLoader getToolsClassLoader(Dependency[] dependencies) throws Exception {
        return this.toClassLoader(this.getToolsClassPath(dependencies));
    }

    protected List<String> getToolsClassPath() throws Exception {
        Dependency portletApiDependency;
        URL url;
        URI uri;
        ArrayList<String> toolsClassPath = new ArrayList<String>();
        if (this.appServerLibGlobalDir != null && this.appServerLibGlobalDir.exists()) {
            Collection globalJarFiles = FileUtils.listFiles((File)this.appServerLibGlobalDir, (String[])new String[]{"jar"}, (boolean)false);
            for (File file : globalJarFiles) {
                uri = file.toURI();
                url = uri.toURL();
                toolsClassPath.add(url.toString());
            }
            Dependency jalopyDependency = this.createDependency("jalopy", "jalopy", "1.5rc3", "", "jar");
            this.addDependencyToClassPath(toolsClassPath, jalopyDependency);
            Dependency qdoxDependency = this.createDependency("com.thoughtworks.qdox", "qdox", "1.12", "", "jar");
            this.addDependencyToClassPath(toolsClassPath, qdoxDependency);
            ClassLoader globalClassLoader = this.toClassLoader(toolsClassPath);
            try {
                globalClassLoader.loadClass("javax.activation.MimeType");
            }
            catch (ClassNotFoundException cnfe) {
                Dependency activationDependency = this.createDependency("javax.activation", "activation", "1.1", "", "jar");
                this.addDependencyToClassPath(toolsClassPath, activationDependency);
            }
            try {
                globalClassLoader.loadClass("javax.mail.Message");
            }
            catch (ClassNotFoundException cnfe) {
                Dependency mailDependency = this.createDependency("javax.mail", "mail", "1.4", "", "jar");
                this.addDependencyToClassPath(toolsClassPath, mailDependency);
            }
            try {
                globalClassLoader.loadClass("com.liferay.portal.kernel.util.ReleaseInfo");
            }
            catch (ClassNotFoundException cnfe) {
                Dependency portalServiceDependency = this.createDependency("com.liferay.portal", "portal-service", this.liferayVersion, "", "jar");
                this.addDependencyToClassPath(toolsClassPath, portalServiceDependency);
            }
            try {
                globalClassLoader.loadClass("javax.portlet.Portlet");
            }
            catch (ClassNotFoundException cnfe) {
                portletApiDependency = this.createDependency("javax.portlet", "portlet-api", "2.0", "", "jar");
                this.addDependencyToClassPath(toolsClassPath, portletApiDependency);
            }
            try {
                globalClassLoader.loadClass("javax.servlet.ServletRequest");
            }
            catch (ClassNotFoundException cnfe) {
                Dependency servletApiDependency = this.createDependency("javax.servlet", "servlet-api", "2.5", "", "jar");
                this.addDependencyToClassPath(toolsClassPath, servletApiDependency);
            }
            try {
                globalClassLoader.loadClass("javax.servlet.jsp.JspPage");
            }
            catch (ClassNotFoundException cnfe) {
                Dependency jspApiDependency = this.createDependency("javax.servlet.jsp", "jsp-api", "2.1", "", "jar");
                this.addDependencyToClassPath(toolsClassPath, jspApiDependency);
            }
        } else {
            Dependency jalopyDependency = this.createDependency("jalopy", "jalopy", "1.5rc3", "", "jar");
            this.addDependencyToClassPath(toolsClassPath, jalopyDependency);
            Dependency qdoxDependency = this.createDependency("com.thoughtworks.qdox", "qdox", "1.12", "", "jar");
            this.addDependencyToClassPath(toolsClassPath, qdoxDependency);
            Dependency activationDependency = this.createDependency("javax.activation", "activation", "1.1", "", "jar");
            this.addDependencyToClassPath(toolsClassPath, activationDependency);
            Dependency mailDependency = this.createDependency("javax.mail", "mail", "1.4", "", "jar");
            this.addDependencyToClassPath(toolsClassPath, mailDependency);
            Dependency portalServiceDependency = this.createDependency("com.liferay.portal", "portal-service", this.liferayVersion, "", "jar");
            this.addDependencyToClassPath(toolsClassPath, portalServiceDependency);
            portletApiDependency = this.createDependency("javax.portlet", "portlet-api", "2.0", "", "jar");
            this.addDependencyToClassPath(toolsClassPath, portletApiDependency);
            Dependency servletApiDependency = this.createDependency("javax.servlet", "servlet-api", "2.5", "", "jar");
            this.addDependencyToClassPath(toolsClassPath, servletApiDependency);
            Dependency jspApiDependency = this.createDependency("javax.servlet.jsp", "jsp-api", "2.1", "", "jar");
            this.addDependencyToClassPath(toolsClassPath, jspApiDependency);
        }
        Collection portalJarFiles = FileUtils.listFiles((File)this.appServerLibPortalDir, (String[])new String[]{"jar"}, (boolean)false);
        for (File file : portalJarFiles) {
            uri = file.toURI();
            url = uri.toURL();
            toolsClassPath.add(url.toString());
        }
        this.getLog().debug((CharSequence)"Tools class path:");
        for (String path : toolsClassPath) {
            this.getLog().debug((CharSequence)("\t" + path));
        }
        return toolsClassPath;
    }

    protected List<String> getToolsClassPath(Dependency[] dependencies) throws Exception {
        List<String> toolsClassPath = this.getToolsClassPath();
        for (Dependency dependency : dependencies) {
            this.addDependencyToClassPath(toolsClassPath, dependency);
        }
        return toolsClassPath;
    }

    protected void initPortalProperties() throws Exception {
        if ((this.appServerPortalDir == null || !this.appServerPortalDir.exists()) && Validator.isNotNull(this.liferayVersion)) {
            this.appServerPortalDir = new File(this.workDir, "appServerPortalDir");
            if (!this.appServerPortalDir.exists()) {
                this.appServerPortalDir.mkdirs();
            }
            Dependency dependency = this.createDependency("com.liferay.portal", "portal-web", this.liferayVersion, "", "war");
            Artifact artifact = this.resolveArtifact(dependency);
            UnArchiver unArchiver = this.archiverManager.getUnArchiver(artifact.getFile());
            unArchiver.setDestDirectory(this.appServerPortalDir);
            unArchiver.setOverwrite(false);
            unArchiver.setSourceFile(artifact.getFile());
            unArchiver.extract();
        }
        if (this.appServerPortalDir != null && this.appServerPortalDir.exists()) {
            if (this.appServerClassesPortalDir == null) {
                this.appServerClassesPortalDir = new File(this.appServerPortalDir, "WEB-INF/classes");
            }
            if (this.appServerLibPortalDir == null) {
                this.appServerLibPortalDir = new File(this.appServerPortalDir, "WEB-INF/lib");
            }
            if (this.appServerTldPortalDir == null) {
                this.appServerTldPortalDir = new File(this.appServerPortalDir, "WEB-INF/tld");
            }
        }
    }

    protected void initUtils() throws Exception {
        ClassLoader classLoader = this.getToolsClassLoader();
        Class<?> clazz = classLoader.loadClass("com.liferay.portal.util.EntityResolver");
        EntityResolver entityResolver = (EntityResolver)clazz.newInstance();
        SAXReaderUtil.setEntityResolver(entityResolver);
    }

    protected Artifact resolveArtifact(Dependency dependency) throws Exception {
        Artifact artifact = null;
        artifact = Validator.isNull(dependency.getClassifier()) ? this.artifactFactory.createArtifact(dependency.getGroupId(), dependency.getArtifactId(), dependency.getVersion(), dependency.getScope(), dependency.getType()) : this.artifactFactory.createArtifactWithClassifier(dependency.getGroupId(), dependency.getArtifactId(), dependency.getVersion(), dependency.getType(), dependency.getClassifier());
        this.artifactResolver.resolve(artifact, this.remoteArtifactRepositories, this.localArtifactRepository);
        return artifact;
    }

    protected URI resolveArtifactFileURI(Dependency dependency) throws Exception {
        Artifact artifact = this.resolveArtifact(dependency);
        File file = artifact.getFile();
        return file.toURI();
    }

    protected MavenProject resolveProject(Artifact artifact) throws Exception {
        Artifact pomArtifact = artifact;
        String type = artifact.getType();
        if (!type.equals("pom")) {
            pomArtifact = this.artifactFactory.createArtifact(artifact.getGroupId(), artifact.getArtifactId(), artifact.getVersion(), "", "pom");
        }
        DefaultProjectBuildingRequest projectBuildingRequest = new DefaultProjectBuildingRequest();
        projectBuildingRequest.setLocalRepository(this.localArtifactRepository);
        projectBuildingRequest.setRemoteRepositories(this.remoteArtifactRepositories);
        projectBuildingRequest.setRepositorySession(this.session.getRepositorySession());
        ArrayList<String> activeProfileIds = new ArrayList<String>();
        MavenExecutionRequest mavenExecutionRequest = this.session.getRequest();
        for (String activeProfile : mavenExecutionRequest.getActiveProfiles()) {
            activeProfileIds.add(activeProfile);
        }
        projectBuildingRequest.setActiveProfileIds(activeProfileIds);
        projectBuildingRequest.setProfiles(mavenExecutionRequest.getProfiles());
        ProjectBuildingResult projectBuildingResult = this.projectBuilder.build(pomArtifact, true, (ProjectBuildingRequest)projectBuildingRequest);
        return projectBuildingResult.getProject();
    }

    protected ClassLoader toClassLoader(List<String> classPath) throws Exception {
        ArrayList<URL> urls = new ArrayList<URL>();
        for (String path : classPath) {
            urls.add(new URL(path));
        }
        return new URLClassLoader(urls.toArray(new URL[urls.size()]), null);
    }

    static {
        _majorVersionPattern = Pattern.compile("(\\d+[.]\\d+)");
    }
}

