/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.maven.plugins;

import com.liferay.maven.plugins.AbstractToolsLiferayMojo;
import com.liferay.maven.plugins.util.FileUtil;
import com.liferay.maven.plugins.util.StringUtil;
import com.liferay.maven.plugins.util.Validator;
import java.io.File;
import java.net.URI;
import java.net.URL;
import java.util.List;
import org.apache.maven.plugin.MojoExecutionException;

public class ServiceBuilderMojo
extends AbstractToolsLiferayMojo {
    private String apiBaseDir;
    private String apiDir;
    private boolean autoNamespaceTables;
    private String baseDir;
    private String beanLocatorUtil;
    private String hbmFileName;
    private String implBaseDir;
    private String implDir;
    private String implResourcesDir;
    private String jsonFileName;
    private String modelHintsFileName;
    private String ormFileName;
    private String pluginName;
    private String pluginType;
    private List<String> postBuildGoals;
    private String propsUtil;
    private String remotingFileName;
    private long serviceBuildNumber;
    private boolean serviceBuildNumberIncrement;
    private String serviceFileName;
    private String springBaseFileName;
    private String springClusterFileName;
    private String springDynamicDataSourceFileName;
    private String springFileName;
    private String springHibernateFileName;
    private String springInfrastructureFileName;
    private String springShardDataSourceFileName;
    private String sqlDir;
    private String sqlFileName;
    private String sqlIndexesFileName;
    private String sqlIndexesPropertiesFileName;
    private String sqlSequencesFileName;
    private String targetEntityName;
    private String webappBaseDir;

    protected void copyServicePropertiesFile() throws Exception {
        File servicePropertiesFile = new File(this.implResourcesDir, "service.properties");
        if (servicePropertiesFile.exists()) {
            FileUtil.copyFile(servicePropertiesFile, new File(this.implDir, "service.properties"));
        }
    }

    @Override
    protected void doExecute() throws Exception {
        String packaging = this.project.getPackaging();
        if (packaging.equals("pom")) {
            this.getLog().info((CharSequence)("Skipping " + this.project.getArtifactId()));
            return;
        }
        String artifactId = this.project.getArtifactId();
        if (this.pluginType.equals("ext") && (artifactId.endsWith("ext-util-bridges") || artifactId.endsWith("ext-util-java") || artifactId.endsWith("ext-util-taglib"))) {
            this.getLog().info((CharSequence)("Skipping " + artifactId));
            return;
        }
        if (this.pluginType.equals("ext")) {
            StringBuilder sb = new StringBuilder();
            sb.append("WARNING: Support for ServiceBuilder in EXT plugins ");
            sb.append("will be deprecated in future versions. EXT plugins ");
            sb.append("are designed to override the portal's core code that ");
            sb.append("cannot be done with hooks, layout templates, ");
            sb.append("portlets, or themes. EXT plugins are not meant to ");
            sb.append("contain new custom services. Please migrate your ");
            sb.append("service.xml to a portlet plugin.");
            this.getLog().warn((CharSequence)sb.toString());
        }
        this.initProperties();
        if (Validator.isNull(this.serviceFileName)) {
            throw new MojoExecutionException("Unable to find service.xml with path " + this.serviceFileName);
        }
        File inputFile = new File(this.serviceFileName);
        if (!inputFile.exists()) {
            throw new MojoExecutionException("Unable to find service.xml with path " + inputFile.getAbsolutePath());
        }
        this.getLog().info((CharSequence)("Building from " + this.serviceFileName));
        this.copyServicePropertiesFile();
        FileUtil.mkdirs(this.sqlDir);
        File tempServiceFile = null;
        if (this.pluginType.equals("ext") && this.serviceFileName.contains("/main/resources/")) {
            File serviceFile = new File(this.serviceFileName);
            tempServiceFile = new File(StringUtil.replace(this.serviceFileName, "/main/resources/", "/main/java/"));
            FileUtil.copyFile(serviceFile, tempServiceFile);
        }
        String[] args = new String[]{"service.input.file=" + this.serviceFileName, "service.hbm.file=" + this.hbmFileName, "service.orm.file=" + this.ormFileName, "service.model.hints.file=" + this.modelHintsFileName, "service.spring.file=" + this.springFileName, "service.spring.base.file=" + this.springBaseFileName, "service.spring.cluster.file=" + this.springClusterFileName, "service.spring.dynamic.data.source.file=" + this.springDynamicDataSourceFileName, "service.spring.hibernate.file=" + this.springHibernateFileName, "service.spring.infrastructure.file=" + this.springInfrastructureFileName, "service.spring.shard.data.source.file=" + this.springShardDataSourceFileName, "service.api.dir=" + this.apiDir, "service.impl.dir=" + this.implDir, "service.json.file=" + this.jsonFileName, "service.remoting.file=" + this.remotingFileName, "service.sql.dir=" + this.sqlDir, "service.sql.file=" + this.sqlFileName, "service.sql.indexes.file=" + this.sqlIndexesFileName, "service.sql.indexes.properties.file=" + this.sqlIndexesPropertiesFileName, "service.sql.sequences.file=" + this.sqlSequencesFileName, "service.auto.namespace.tables=" + this.autoNamespaceTables, "service.bean.locator.util=" + this.beanLocatorUtil, "service.props.util=" + this.propsUtil, "service.plugin.name=" + this.pluginName, "service.target.entity.name=" + this.targetEntityName, "service.test.dir=", "service.build.number=" + this.serviceBuildNumber, "service.build.number.increment=" + this.serviceBuildNumberIncrement};
        this.executeTool("com.liferay.portal.tools.servicebuilder.ServiceBuilder", this.getProjectClassLoader(), args);
        if (tempServiceFile != null) {
            FileUtil.delete(tempServiceFile);
        }
        this.moveServicePropertiesFile();
    }

    @Override
    protected List<String> getProjectClassPath() throws Exception {
        List<String> projectClassPath = super.getProjectClassPath();
        File file = new File(this.implResourcesDir);
        URI uri = file.toURI();
        URL url = uri.toURL();
        projectClassPath.add(0, url.toString());
        return projectClassPath;
    }

    @Override
    protected void initPortalProperties() throws Exception {
        super.initPortalProperties();
        this.initProperties();
    }

    protected void initProperties() throws Exception {
        String webappResourcesDir;
        String webappDir;
        if (Validator.isNotNull(this.apiBaseDir) || Validator.isNotNull(this.implBaseDir) || Validator.isNotNull(this.webappBaseDir)) {
            if (Validator.isNull(this.apiBaseDir)) {
                this.apiBaseDir = this.baseDir;
            }
            if (Validator.isNull(this.implBaseDir) && Validator.isNotNull(this.webappBaseDir)) {
                this.implBaseDir = this.webappBaseDir;
            } else if (Validator.isNull(this.implBaseDir) && Validator.isNotNull(this.apiBaseDir)) {
                this.implBaseDir = this.baseDir;
            }
            if (Validator.isNull(this.webappBaseDir)) {
                this.webappBaseDir = this.baseDir;
            }
        }
        if (Validator.isNotNull(this.apiBaseDir)) {
            this.apiDir = this.apiBaseDir.concat("/src/main/java");
        }
        if (Validator.isNotNull(this.implBaseDir)) {
            this.implDir = this.implBaseDir.concat("/src/main/java");
            this.implResourcesDir = this.implBaseDir.concat("/src/main/resources");
            if (this.pluginType.equals("ext")) {
                this.hbmFileName = this.implResourcesDir.concat("/META-INF/ext-hbm.xml");
                this.modelHintsFileName = this.implResourcesDir.concat("/META-INF/ext-model-hints.xml");
                this.ormFileName = this.implResourcesDir.concat("/META-INF/ext-orm.xml");
                this.springFileName = this.implResourcesDir.concat("/META-INF/ext-spring.xml");
            }
        }
        if (Validator.isNotNull(this.webappBaseDir)) {
            webappDir = this.webappBaseDir.concat("/src/main/webapp");
            webappResourcesDir = this.webappBaseDir.concat("/src/main/resources");
            if (this.pluginType.equals("ext")) {
                this.jsonFileName = webappDir.concat("/html/js/liferay/service.js");
                this.remotingFileName = webappDir.concat("/WEB-INF/remoting-servlet-ext.xml");
            } else {
                this.hbmFileName = webappResourcesDir.concat("/META-INF/portlet-hbm.xml");
                this.jsonFileName = webappDir.concat("/js/service.js");
                this.modelHintsFileName = webappResourcesDir.concat("/META-INF/portlet-model-hints.xml");
                this.ormFileName = webappResourcesDir.concat("/META-INF/portlet-orm.xml");
                this.serviceFileName = webappDir.concat("/WEB-INF/service.xml");
                this.springBaseFileName = webappResourcesDir.concat("/META-INF/base-spring.xml");
                this.springClusterFileName = webappResourcesDir.concat("/META-INF/cluster-spring.xml");
                this.springDynamicDataSourceFileName = webappResourcesDir.concat("/META-INF/dynamic-data-source-spring.xml");
                this.springFileName = webappResourcesDir.concat("/META-INF/portlet-spring.xml");
                this.springHibernateFileName = webappResourcesDir.concat("/META-INF/hibernate-spring.xml");
                this.springInfrastructureFileName = webappResourcesDir.concat("/META-INF/infrastructure-spring.xml");
                this.springShardDataSourceFileName = webappResourcesDir.concat("/META-INF/shard-data-source-spring.xml");
                this.sqlDir = webappDir.concat("/WEB-INF/sql");
                if (Validator.isNull(this.serviceFileName)) {
                    this.serviceFileName = webappDir.concat("/WEB-INF/service.xml");
                }
            }
        }
        if (Validator.isNull(this.sqlDir)) {
            this.sqlDir = this.baseDir.concat("/src/main/webapp/WEB-INF/sql");
        }
        if (this.pluginType.equals("ext")) {
            if (Validator.isNull(this.beanLocatorUtil)) {
                this.beanLocatorUtil = "com.liferay.portal.kernel.bean.PortalBeanLocatorUtil";
            }
            if (Validator.isNull(this.propsUtil)) {
                this.propsUtil = "com.liferay.portal.util.PropsUtil";
            }
            if (Validator.isNull(this.sqlFileName)) {
                this.sqlFileName = "portal-tables.sql";
            }
            this.pluginName = null;
            this.springBaseFileName = null;
            this.springClusterFileName = null;
            this.springDynamicDataSourceFileName = null;
            this.springHibernateFileName = null;
            this.springInfrastructureFileName = null;
            this.springShardDataSourceFileName = null;
        } else {
            webappDir = this.baseDir.concat("/src/main/webapp");
            webappResourcesDir = this.baseDir.concat("/src/main/resources");
            if (Validator.isNull(this.apiDir)) {
                this.apiDir = this.baseDir.concat("/src/main/java");
            }
            if (Validator.isNull(this.beanLocatorUtil)) {
                this.beanLocatorUtil = "com.liferay.util.bean.PortletBeanLocatorUtil";
            }
            if (Validator.isNull(this.hbmFileName)) {
                this.hbmFileName = webappResourcesDir.concat("/META-INF/portlet-hbm.xml");
            }
            if (Validator.isNull(this.implDir)) {
                this.implDir = this.baseDir.concat("/src/main/java");
                this.implResourcesDir = this.baseDir.concat("/src/main/resources");
            }
            if (Validator.isNull(this.jsonFileName)) {
                this.jsonFileName = webappDir.concat("/js/service.js");
            }
            if (Validator.isNull(this.modelHintsFileName)) {
                this.modelHintsFileName = webappResourcesDir.concat("/META-INF/portlet-model-hints.xml");
            }
            if (Validator.isNull(this.ormFileName)) {
                this.ormFileName = webappResourcesDir.concat("/META-INF/portlet-orm.xml");
            }
            if (Validator.isNull(this.propsUtil)) {
                this.propsUtil = "com.liferay.util.service.ServiceProps";
            }
            if (Validator.isNull(this.serviceFileName)) {
                this.serviceFileName = webappDir.concat("/WEB-INF/service.xml");
            }
            if (Validator.isNull(this.springBaseFileName)) {
                this.springBaseFileName = webappResourcesDir.concat("/META-INF/base-spring.xml");
            }
            if (Validator.isNull(this.springClusterFileName)) {
                this.springClusterFileName = webappResourcesDir.concat("/META-INF/cluster-spring.xml");
            }
            if (Validator.isNull(this.springDynamicDataSourceFileName)) {
                this.springDynamicDataSourceFileName = webappResourcesDir.concat("/META-INF/dynamic-data-source-spring.xml");
            }
            if (Validator.isNull(this.springFileName)) {
                this.springFileName = webappResourcesDir.concat("/META-INF/portlet-spring.xml");
            }
            if (Validator.isNull(this.springHibernateFileName)) {
                this.springHibernateFileName = webappResourcesDir.concat("/META-INF/hibernate-spring.xml");
            }
            if (Validator.isNull(this.springInfrastructureFileName)) {
                this.springInfrastructureFileName = webappResourcesDir.concat("/META-INF/infrastructure-spring.xml");
            }
            if (Validator.isNull(this.springShardDataSourceFileName)) {
                this.springShardDataSourceFileName = webappResourcesDir.concat("/META-INF/shard-data-source-spring.xml");
            }
            if (Validator.isNull(this.sqlFileName)) {
                this.sqlFileName = "tables.sql";
            }
        }
    }

    protected void moveServicePropertiesFile() throws Exception {
        FileUtil.move(new File(this.implDir, "service.properties"), new File(this.implResourcesDir, "service.properties"));
    }
}

