/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.maven.plugins;

import com.liferay.maven.plugins.AbstractLiferayMojo;
import com.liferay.portal.kernel.util.FileUtil;
import com.liferay.portal.tools.ExtInfoBuilder;
import com.liferay.util.ant.CopyTask;
import java.io.File;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.model.Dependency;
import org.codehaus.plexus.archiver.UnArchiver;
import org.codehaus.plexus.components.io.fileselectors.FileSelector;
import org.codehaus.plexus.components.io.fileselectors.IncludeExcludeFileSelector;

public class ExtBuilderMojo
extends AbstractLiferayMojo {
    private boolean dependencyAddClassifier;
    private boolean dependencyAddVersion;
    private boolean dependencyAddVersionAndClassifier;
    private boolean dependencyCopyTransitive;
    private String pluginName;
    private File sqlSourceDir;
    private File webappDir;

    protected void copyJarAndClasses(Artifact artifact, File jarDir, String jarName) throws Exception {
        File serviceJarFile = new File(jarDir, jarName);
        FileUtil.copyFile((File)artifact.getFile(), (File)serviceJarFile);
        File classesDir = new File(jarDir, "classes");
        classesDir.mkdirs();
        String[] excludes = new String[]{"META-INF/**", "portal-*.properties", "system-*.properties"};
        this.unpack(artifact.getFile(), classesDir, excludes, null);
    }

    protected void copyUtilLibrary(Artifact artifact, File utilDir, File implClassesDir, String utilJarName) throws Exception {
        File utilJarFile = new File(utilDir, "ext-" + utilJarName);
        FileUtil.copyFile((File)artifact.getFile(), (File)utilJarFile);
        File dependencyUtilJarFile = new File(implClassesDir, "ext-" + this.pluginName + "-" + utilJarName);
        FileUtil.copyFile((File)artifact.getFile(), (File)dependencyUtilJarFile);
    }

    protected void doExecute() throws Exception {
        if (this.dependencyAddVersionAndClassifier) {
            this.dependencyAddVersion = true;
            this.dependencyAddClassifier = true;
        }
        File implDir = new File(this.webappDir, "WEB-INF/ext-impl");
        implDir.mkdirs();
        File implClassesDir = new File(implDir, "classes/com/liferay/portal/deploy/dependencies");
        implClassesDir.mkdirs();
        File globalLibDir = new File(this.webappDir, "WEB-INF/ext-lib/global");
        globalLibDir.mkdirs();
        File portalLibDir = new File(this.webappDir, "WEB-INF/ext-lib/portal");
        portalLibDir.mkdirs();
        File serviceDir = new File(this.webappDir, "WEB-INF/ext-service");
        serviceDir.mkdirs();
        File sqlDir = new File(this.webappDir, "WEB-INF/sql");
        sqlDir.mkdirs();
        File utilBridgesDir = new File(this.webappDir, "WEB-INF/ext-util-bridges");
        utilBridgesDir.mkdirs();
        File utilJavaDir = new File(this.webappDir, "WEB-INF/ext-util-java");
        utilJavaDir.mkdirs();
        File utilTaglibDir = new File(this.webappDir, "WEB-INF/ext-util-taglib");
        utilTaglibDir.mkdirs();
        File webDir = new File(this.webappDir, "WEB-INF/ext-web/docroot");
        webDir.mkdirs();
        this.workDir.mkdirs();
        String groupId = this.project.getGroupId();
        File extImplFile = null;
        for (Object dependencyObj : this.project.getDependencies()) {
            Dependency dependency = (Dependency)dependencyObj;
            if (!groupId.equals(dependency.getGroupId())) continue;
            Artifact artifact = this.resolveArtifact(dependency);
            String artifactId = artifact.getArtifactId();
            if (artifactId.endsWith("ext-impl")) {
                extImplFile = artifact.getFile();
                this.copyJarAndClasses(artifact, implDir, "ext-impl.jar");
                this.copyLibraryDependencies(portalLibDir, artifact, this.dependencyAddVersion, this.dependencyAddClassifier, this.dependencyCopyTransitive);
                continue;
            }
            if (artifactId.endsWith("ext-lib-global")) {
                this.copyLibraryDependencies(globalLibDir, artifact, this.dependencyAddVersion, this.dependencyAddClassifier, this.dependencyCopyTransitive);
                continue;
            }
            if (artifactId.endsWith("ext-lib-portal")) {
                this.copyLibraryDependencies(portalLibDir, artifact, this.dependencyAddVersion, this.dependencyAddClassifier, this.dependencyCopyTransitive);
                continue;
            }
            if (artifactId.endsWith("ext-service")) {
                this.copyJarAndClasses(artifact, serviceDir, "ext-service.jar");
                this.copyLibraryDependencies(globalLibDir, artifact, this.dependencyAddVersion, this.dependencyAddClassifier, this.dependencyCopyTransitive);
                continue;
            }
            if (artifactId.endsWith("ext-util-bridges")) {
                this.copyUtilLibrary(artifact, utilBridgesDir, implClassesDir, "util-bridges.jar");
                this.copyLibraryDependencies(portalLibDir, artifact, this.dependencyAddVersion, this.dependencyAddClassifier, this.dependencyCopyTransitive);
                continue;
            }
            if (artifactId.endsWith("ext-util-java")) {
                this.copyUtilLibrary(artifact, utilJavaDir, implClassesDir, "util-java.jar");
                this.copyLibraryDependencies(portalLibDir, artifact, this.dependencyAddVersion, this.dependencyAddClassifier, this.dependencyCopyTransitive);
                continue;
            }
            if (artifactId.endsWith("ext-util-taglib")) {
                this.copyUtilLibrary(artifact, utilTaglibDir, implClassesDir, "util-taglib.jar");
                this.copyLibraryDependencies(portalLibDir, artifact, this.dependencyAddVersion, this.dependencyAddClassifier, this.dependencyCopyTransitive);
                continue;
            }
            if (!artifactId.endsWith("ext-web")) continue;
            String[] excludes = new String[]{"META-INF/**"};
            this.unpack(artifact.getFile(), webDir, excludes, null);
            this.copyLibraryDependencies(portalLibDir, artifact, this.dependencyAddVersion, this.dependencyAddClassifier, this.dependencyCopyTransitive);
        }
        this.unpack(extImplFile, this.workDir, null, new String[]{"portal-*.properties", "system-*.properties"});
        CopyTask.copyDirectory((File)this.workDir, (File)new File(webDir, "WEB-INF/classes"), (String)"portal-*.properties,system-*.properties", null);
        FileUtil.copyDirectory((File)this.sqlSourceDir, (File)sqlDir);
        String dirName = this.webappDir.getAbsolutePath() + "/WEB-INF";
        ExtInfoBuilder infoBuilder = new ExtInfoBuilder(dirName, dirName, this.pluginName);
    }

    protected void unpack(File srcFile, File destDir, String[] excludes, String[] includes) throws Exception {
        UnArchiver unArchiver = this.archiverManager.getUnArchiver(srcFile);
        unArchiver.setDestDirectory(destDir);
        unArchiver.setSourceFile(srcFile);
        IncludeExcludeFileSelector includeExcludeFileSelector = new IncludeExcludeFileSelector();
        includeExcludeFileSelector.setExcludes(excludes);
        includeExcludeFileSelector.setIncludes(includes);
        unArchiver.setFileSelectors(new FileSelector[]{includeExcludeFileSelector});
        unArchiver.extract();
    }
}

