/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.maven.plugins;

import com.liferay.portal.cache.MultiVMPoolImpl;
import com.liferay.portal.cache.memory.MemoryPortalCacheManager;
import com.liferay.portal.kernel.cache.MultiVMPool;
import com.liferay.portal.kernel.cache.MultiVMPoolUtil;
import com.liferay.portal.kernel.cache.PortalCacheManager;
import com.liferay.portal.kernel.util.FileUtil;
import com.liferay.portal.kernel.util.Html;
import com.liferay.portal.kernel.util.HtmlUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.util.HtmlImpl;
import com.liferay.portal.util.InitUtil;
import com.liferay.portal.util.PropsUtil;
import com.liferay.util.ant.CopyTask;
import java.io.File;
import java.lang.reflect.Method;
import java.net.URI;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.List;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.factory.ArtifactFactory;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.resolver.ArtifactResolver;
import org.apache.maven.model.Dependency;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.MavenProjectBuilder;
import org.codehaus.plexus.archiver.UnArchiver;
import org.codehaus.plexus.archiver.manager.ArchiverManager;
import org.codehaus.plexus.components.io.fileselectors.FileSelector;
import org.codehaus.plexus.components.io.fileselectors.IncludeExcludeFileSelector;

public abstract class AbstractLiferayMojo
extends AbstractMojo {
    protected File appServerClassesPortalDir;
    protected File appServerLibGlobalDir;
    protected File appServerLibPortalDir;
    protected File appServerPortalDir;
    protected File appServerTldPortalDir;
    protected ArchiverManager archiverManager;
    protected ArtifactFactory artifactFactory;
    protected ArtifactResolver artifactResolver;
    protected String liferayVersion;
    protected ArtifactRepository localArtifactRepository;
    protected String pluginType;
    protected MavenProject project;
    protected MavenProjectBuilder projectBuilder;
    protected List remoteArtifactRepositories;
    protected File workDir;

    public void execute() throws MojoExecutionException {
        try {
            this.initPortal();
            this.initClassLoader();
            this.doExecute();
        }
        catch (Exception e) {
            if (e instanceof MojoExecutionException) {
                throw (MojoExecutionException)e;
            }
            throw new MojoExecutionException(e.getMessage(), e);
        }
    }

    protected void copyLibraryDependencies(File libDir, Artifact artifact) throws Exception {
        this.copyLibraryDependencies(libDir, artifact, false, false, false);
    }

    protected void copyLibraryDependencies(File libDir, Artifact artifact, boolean dependencyAddVersion, boolean dependencyAddClassifier, boolean copyTransitive) throws Exception {
        MavenProject mavenProject = this.resolveProject(artifact);
        List dependencies = mavenProject.getDependencies();
        for (Dependency dependency : dependencies) {
            String type;
            String scope = dependency.getScope();
            if (Validator.isNotNull((String)scope) && (scope.equalsIgnoreCase("provided") || scope.equalsIgnoreCase("test")) || (type = dependency.getType()).equalsIgnoreCase("pom")) continue;
            Artifact libArtifact = this.resolveArtifact(dependency);
            String libJarFileName = libArtifact.getArtifactId();
            if (dependencyAddVersion && Validator.isNotNull((String)libArtifact.getVersion())) {
                libJarFileName = libJarFileName + "-" + libArtifact.getVersion();
            }
            if (dependencyAddClassifier && Validator.isNotNull((String)libArtifact.getClassifier())) {
                libJarFileName = libJarFileName + "-" + libArtifact.getClassifier();
            }
            File libArtifactFile = libArtifact.getFile();
            libJarFileName = libJarFileName + "." + FileUtil.getExtension((String)libArtifactFile.getName());
            CopyTask.copyFile((File)libArtifactFile, (File)libDir, (String)libJarFileName, null, (boolean)true, (boolean)true);
            if (!copyTransitive) continue;
            this.copyLibraryDependencies(libDir, libArtifact, dependencyAddVersion, dependencyAddClassifier, copyTransitive);
        }
    }

    protected Dependency createDependency(String groupId, String artifactId, String version, String classifier, String type) {
        Dependency dependency = new Dependency();
        dependency.setArtifactId(artifactId);
        dependency.setClassifier(classifier);
        dependency.setGroupId(groupId);
        dependency.setType(type);
        dependency.setVersion(version);
        return dependency;
    }

    protected abstract void doExecute() throws Exception;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void initClassLoader() throws Exception {
        Class<AbstractLiferayMojo> clazz = AbstractLiferayMojo.class;
        synchronized (AbstractLiferayMojo.class) {
            Class<?> clazz2 = ((Object)((Object)this)).getClass();
            URLClassLoader urlClassLoader = (URLClassLoader)clazz2.getClassLoader();
            Method method = URLClassLoader.class.getDeclaredMethod("addURL", URL.class);
            method.setAccessible(true);
            for (Object object : this.project.getCompileClasspathElements()) {
                String path = (String)object;
                File file = new File(path);
                URI uri = file.toURI();
                method.invoke((Object)urlClassLoader, uri.toURL());
            }
            if (this.appServerLibPortalDir != null && this.appServerLibPortalDir.exists()) {
                String[] fileNames;
                for (String fileName : fileNames = FileUtil.listFiles((File)this.appServerLibPortalDir)) {
                    File file = new File(this.appServerLibPortalDir, fileName);
                    URI uri = file.toURI();
                    method.invoke((Object)urlClassLoader, uri.toURL());
                }
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    protected void initPortal() throws Exception {
        if (this.appServerPortalDir != null && this.appServerPortalDir.exists()) {
            if (Validator.isNull((Object)this.appServerClassesPortalDir)) {
                this.appServerClassesPortalDir = new File(this.appServerPortalDir, "WEB-INF/classes");
            }
            if (Validator.isNull((Object)this.appServerLibPortalDir)) {
                this.appServerLibPortalDir = new File(this.appServerPortalDir, "WEB-INF/lib");
            }
            if (Validator.isNull((Object)this.appServerTldPortalDir)) {
                this.appServerTldPortalDir = new File(this.appServerPortalDir, "WEB-INF/tld");
            }
        }
        if ((this.appServerPortalDir == null || !this.appServerPortalDir.exists()) && Validator.isNotNull((String)this.liferayVersion)) {
            this.appServerPortalDir = new File(this.workDir, "appServerPortalDir");
            if (!this.appServerPortalDir.exists()) {
                this.appServerPortalDir.mkdirs();
            }
            Dependency dependency = this.createDependency("com.liferay.portal", "portal-web", this.liferayVersion, "", "war");
            Artifact artifact = this.resolveArtifact(dependency);
            UnArchiver unArchiver = this.archiverManager.getUnArchiver(artifact.getFile());
            unArchiver.setDestDirectory(this.appServerPortalDir);
            IncludeExcludeFileSelector includeExcludeFileSelector = new IncludeExcludeFileSelector();
            includeExcludeFileSelector.setExcludes(null);
            includeExcludeFileSelector.setIncludes(new String[]{"WEB-INF/lib/*.jar"});
            unArchiver.setFileSelectors(new FileSelector[]{includeExcludeFileSelector});
            unArchiver.setOverwrite(false);
            unArchiver.setSourceFile(artifact.getFile());
            unArchiver.extract();
            if (Validator.isNull((Object)this.appServerLibPortalDir)) {
                this.appServerLibPortalDir = new File(this.appServerPortalDir, "WEB-INF/lib");
            }
        }
        if (this.appServerLibPortalDir != null) {
            System.setProperty("liferay.lib.portal.dir", this.appServerLibPortalDir.getAbsolutePath());
        }
        PropsUtil.reload();
        PropsUtil.set((String)"resource.actions.read.portlet.resources", (String)Boolean.FALSE.toString());
        PropsUtil.set((String)"spring.configs", (String)"META-INF/service-builder-spring.xml");
        PropsUtil.set((String)"velocity.engine.logger", (String)"org.apache.velocity.runtime.log.NullLogSystem");
        InitUtil.initWithSpring();
        HtmlUtil htmlUtil = new HtmlUtil();
        htmlUtil.setHtml((Html)new HtmlImpl());
        MemoryPortalCacheManager memoryPortalCacheManager = new MemoryPortalCacheManager();
        memoryPortalCacheManager.afterPropertiesSet();
        MultiVMPoolImpl multiVMPoolImpl = new MultiVMPoolImpl();
        multiVMPoolImpl.setPortalCacheManager((PortalCacheManager)memoryPortalCacheManager);
        MultiVMPoolUtil multiVMPoolUtil = new MultiVMPoolUtil();
        multiVMPoolUtil.setMultiVMPool((MultiVMPool)multiVMPoolImpl);
    }

    protected Artifact resolveArtifact(Dependency dependency) throws Exception {
        Artifact artifact = this.artifactFactory.createArtifact(dependency.getGroupId(), dependency.getArtifactId(), dependency.getVersion(), dependency.getClassifier(), dependency.getType());
        this.artifactResolver.resolve(artifact, this.remoteArtifactRepositories, this.localArtifactRepository);
        return artifact;
    }

    protected MavenProject resolveProject(Artifact artifact) throws Exception {
        Artifact pomArtifact = artifact;
        String type = artifact.getType();
        if (!type.equals("pom")) {
            pomArtifact = this.artifactFactory.createArtifact(artifact.getGroupId(), artifact.getArtifactId(), artifact.getVersion(), "", "pom");
        }
        return this.projectBuilder.buildFromRepository(pomArtifact, this.remoteArtifactRepositories, this.localArtifactRepository);
    }
}

