/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.gs.testFramework.utils;

import com.liferay.gs.testFramework.core.SeleniumReadPropertyKeys;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import org.openqa.selenium.By;
import org.openqa.selenium.NoSuchElementException;
import org.openqa.selenium.StaleElementReferenceException;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.ui.ExpectedCondition;
import org.openqa.selenium.support.ui.FluentWait;
import org.openqa.selenium.support.ui.Wait;
import org.openqa.selenium.support.ui.WebDriverWait;

public class SeleniumWaitMethods {
    @SafeVarargs
    public static <R> WebElement findElementWithFluentWait(WebDriver webDriver, By elementLocator, Function<By, ExpectedCondition<R>> ... expectedConditions) {
        SeleniumWaitMethods._applyWaits(elementLocator, SeleniumWaitMethods.getFluentWait(webDriver), expectedConditions);
        WebElement element = webDriver.findElement(elementLocator);
        return element;
    }

    @SafeVarargs
    public static <R> WebElement findElementWithWaitDriver(WebDriver webDriver, By elementLocator, Function<By, ExpectedCondition<R>> ... expectedConditions) {
        WebDriverWait waitDriver = new WebDriverWait(webDriver, (long)SeleniumReadPropertyKeys.getTimeOut());
        SeleniumWaitMethods._applyWaits(elementLocator, (Wait<WebDriver>)waitDriver, expectedConditions);
        WebElement element = webDriver.findElement(elementLocator);
        return element;
    }

    public static Wait<WebDriver> getFluentWait(WebDriver webDriver) {
        return new FluentWait((Object)webDriver).withTimeout((long)SeleniumReadPropertyKeys.getTimeOut(), TimeUnit.SECONDS).pollingEvery(1L, TimeUnit.SECONDS).ignoring(NoSuchElementException.class).ignoring(StaleElementReferenceException.class);
    }

    public static WebDriverWait getWaitDriver(WebDriver webDriver) {
        return new WebDriverWait(webDriver, (long)SeleniumReadPropertyKeys.getTimeOut());
    }

    public static void waitLongTime() {
        try {
            Thread.sleep(2000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public static void waitMediumTime() {
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public static void waitShortTime() {
        try {
            Thread.sleep(400L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public static void waitTime(long milliseconds) {
        try {
            Thread.sleep(milliseconds);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public static void waitVeryLongTime() {
        try {
            Thread.sleep(4000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private static <R> void _applyWaits(By elementLocator, Wait<WebDriver> wait, Function<By, ExpectedCondition<R>>[] expectedConditions) {
        for (Function<By, ExpectedCondition<R>> condition : expectedConditions) {
            wait.until((Function)condition.apply(elementLocator));
        }
    }
}

