/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.gs.testFramework.errorHandling;

import com.liferay.gs.testFramework.errorHandling.IntermittencyChecker;
import org.junit.rules.TestRule;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;
import org.openqa.selenium.WebDriver;

public class RetryTestExecution
implements TestRule {
    private final IntermittencyChecker _intermittencyChecker = new IntermittencyChecker();
    private final int _retryCount;
    private final WebDriver _webDriver;

    public RetryTestExecution(WebDriver webDriver, int retryCount) {
        this._webDriver = webDriver;
        this._retryCount = retryCount;
    }

    public Statement apply(Statement base, Description description) {
        return this._statement(base, description);
    }

    private Statement _statement(final Statement base, final Description description) {
        return new Statement(){

            public void evaluate() throws Throwable {
                Throwable caughtThrowable = null;
                for (int attempt = 1; attempt <= RetryTestExecution.this._retryCount; ++attempt) {
                    try {
                        base.evaluate();
                        RetryTestExecution.this._intermittencyChecker.registerTestSuccess(attempt, description);
                        return;
                    }
                    catch (Throwable t) {
                        RetryTestExecution.this._intermittencyChecker.registerThrowable(RetryTestExecution.this._webDriver, attempt, description, t);
                        caughtThrowable = t;
                        System.err.println(description.getDisplayName() + ": run " + attempt + " failed");
                        System.err.println(description.getDisplayName() + ": stacktrace");
                        caughtThrowable.printStackTrace();
                        continue;
                    }
                }
                RetryTestExecution.this._intermittencyChecker.registerTestFailure(RetryTestExecution.this._retryCount, description);
                System.err.println(description.getDisplayName() + ": giving up after " + RetryTestExecution.this._retryCount + " failures");
                throw caughtThrowable;
            }
        };
    }
}

