/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.gs.testFramework.errorHandling;

import com.liferay.gs.testFramework.errorHandling.AttachmentUploader;
import com.liferay.gs.testFramework.errorHandling.ScreenshotTaker;
import java.io.File;
import java.io.PrintWriter;
import java.io.StringWriter;
import org.junit.runner.Description;
import org.openqa.selenium.WebDriver;

public class IntermittencyChecker {
    public static final String ARTIFACT_FILE_NAME_FORMAT = "Intermittency.#%s.%s.%s.%s";
    private AttachmentUploader _attachmentUploader = new AttachmentUploader();
    private ScreenshotTaker _screenshotTaker = new ScreenshotTaker();

    public void registerTestFailure(int attempts, Description description) {
        this._cleanArtifacts(attempts, description);
    }

    public void registerTestSuccess(int attempts, Description description) {
        if (attempts > 1) {
            System.err.println(this._getWarning(description));
        }
    }

    public void registerThrowable(WebDriver webDriver, int attempt, Description description, Throwable t) {
        this._writeArtifact(webDriver, attempt, t, description);
    }

    private void _cleanArtifacts(int attempts, Description description) {
        for (int attempt = 1; attempt <= attempts; ++attempt) {
            String txtFileName = this._getTxtFileName(attempt, description);
            String screenshotFileName = this._getScreenshotFileName(attempt, description);
            File txtFile = new File("build/test-results/functionalTest/attachments/", txtFileName);
            txtFile.delete();
            File screenshotFile = new File("build/test-results/functionalTest/attachments/", screenshotFileName);
            screenshotFile.delete();
        }
    }

    private String _getScreenshotFileName(int attempt, Description description) {
        return String.format(ARTIFACT_FILE_NAME_FORMAT, attempt, description.getClassName(), description.getMethodName(), "png");
    }

    private String _getTxtFileName(int attempt, Description description) {
        return String.format(ARTIFACT_FILE_NAME_FORMAT, attempt, description.getClassName(), description.getMethodName(), "txt");
    }

    private String _getWarning(Description description) {
        return description.getDisplayName() + ": INTERMITTENCY WARNING - Test has just passed but failed on previous tries!";
    }

    private void _writeArtifact(WebDriver webDriver, int attempt, Throwable t, Description description) {
        StringWriter sw = new StringWriter();
        t.printStackTrace(new PrintWriter(sw));
        String stackTrace = sw.toString();
        String content = this._getWarning(description) + "\nStacktrace:\n" + stackTrace;
        String txtFileName = this._getTxtFileName(attempt, description);
        this._attachmentUploader.setData(content);
        this._attachmentUploader.save(txtFileName);
        String screenshotFileName = this._getScreenshotFileName(attempt, description);
        this._screenshotTaker.take(webDriver);
        this._screenshotTaker.save(screenshotFileName);
    }
}

