/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.gs.testFramework.driver;

import com.liferay.gs.testFramework.driver.WebDriverBuilder;
import com.liferay.gs.testFramework.utils.SeleniumWaitMethods;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.openqa.selenium.WebDriver;

public class WebDriverManager {
    private static ThreadLocal<WebDriver> _driver = new ThreadLocal();
    private static List<WebDriver> _drivers = Collections.synchronizedList(new ArrayList());

    public synchronized WebDriver get() {
        if (_driver.get() == null) {
            WebDriver webDriver = WebDriverBuilder.build();
            _drivers.add(webDriver);
            _driver.set(webDriver);
        }
        return _driver.get();
    }

    public synchronized void quitAll() {
        _drivers.forEach(webDriver -> {
            webDriver.close();
            SeleniumWaitMethods.waitMediumTime();
            SeleniumWaitMethods.waitMediumTime();
            SeleniumWaitMethods.waitMediumTime();
            webDriver.quit();
        });
    }
}

