/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.gs.testFramework.core;

import com.liferay.gs.testFramework.core.SeleniumReadPropertyKeys;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.junit.runners.Suite;
import org.junit.runners.model.InitializationError;
import org.junit.runners.model.RunnerBuilder;
import org.junit.runners.model.RunnerScheduler;

public class ConcurrentSuite
extends Suite {
    private final int _NUMBER_OF_THREADS = SeleniumReadPropertyKeys.getNumberOfBrowserInParallel();

    public ConcurrentSuite(Class<?> clazz, RunnerBuilder builder) throws InitializationError {
        super(clazz, builder);
        this.setScheduler(new MultipleThreadPoolScheduler());
    }

    private class MultipleThreadPoolScheduler
    implements RunnerScheduler {
        private ExecutorService _executor;

        public MultipleThreadPoolScheduler() {
            String threads = System.getProperty("concurrentSuite.numberOfThreads", Integer.toString(ConcurrentSuite.this._NUMBER_OF_THREADS));
            int numThreads = Integer.parseInt(threads);
            this._executor = Executors.newFixedThreadPool(numThreads);
        }

        public void finished() {
            this._executor.shutdown();
            try {
                this._executor.awaitTermination(1L, TimeUnit.HOURS);
            }
            catch (InterruptedException exc) {
                throw new RuntimeException(exc);
            }
        }

        public void schedule(Runnable childStatement) {
            System.out.println(String.format("Scheduled (%s): %s", childStatement.getClass(), childStatement));
            this._executor.submit(childStatement);
        }
    }
}

