/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.gs.testFramework;

import com.liferay.gs.testFramework.SeleniumReadPropertyKeys;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.chrome.ChromeDriver;
import org.openqa.selenium.chrome.ChromeOptions;
import org.openqa.selenium.firefox.FirefoxDriver;
import org.openqa.selenium.phantomjs.PhantomJSDriver;
import org.openqa.selenium.remote.DesiredCapabilities;
import org.openqa.selenium.remote.RemoteWebDriver;

public final class Selenium {
    private static WebDriver driver = null;
    private static String SeleniumGridMachine = SeleniumReadPropertyKeys.getSeleniumGridMachine();
    private static String SeleniumGridDocker = SeleniumReadPropertyKeys.getSeleniumGridDocker();
    private static String PhantomJS_Path = SeleniumReadPropertyKeys.getPhantomJSPath();
    private static String GeckoDriver_Path = SeleniumReadPropertyKeys.getGeckoDriverPath();
    private static String ChromeDriver_Path = SeleniumReadPropertyKeys.getChromeDriverPath();
    private static String DownloadSaveFilePath = SeleniumReadPropertyKeys.getDownloadSaveFilePath();
    private static String configurationErrorMessage = null;

    public static WebDriver getDriver() {
        if (Selenium.defaultPropertiesFilePathWasConfigured()) {
            if (driver == null) {
                Selenium.initDriver();
            }
            return driver;
        }
        System.out.println(configurationErrorMessage);
        return null;
    }

    private static void initDriver() {
        try {
            DesiredCapabilities capabilities = new DesiredCapabilities();
            switch (SeleniumReadPropertyKeys.getPlatformName()) {
                case "ie": {
                    Selenium.configureIE(capabilities);
                    break;
                }
                case "chrome": {
                    Selenium.configureChrome();
                    break;
                }
                case "defaultFF": {
                    Selenium.configureDefaultFF();
                    break;
                }
                case "defaultGC": {
                    Selenium.configureDefaultGC();
                    break;
                }
                case "firefox": {
                    Selenium.configureFirefox(capabilities);
                    break;
                }
                case "phantomjs": {
                    Selenium.configurePhantomJS(capabilities);
                    break;
                }
                case "defaultGCHeadless": {
                    Selenium.configureDefaultGCHeadless();
                    break;
                }
                case "dockerGC": {
                    Selenium.configuraSeleniumGridWithDocker();
                    break;
                }
            }
        }
        catch (MalformedURLException e) {
            System.out.println(e);
        }
    }

    private static void configureDefaultFF() {
        if (Selenium.geckoDriverWasConfigured()) {
            DesiredCapabilities cap = DesiredCapabilities.firefox();
            System.setProperty("webdriver.gecko.driver", GeckoDriver_Path);
            cap.setCapability("marionette", true);
            driver = new FirefoxDriver((Capabilities)cap);
        } else {
            System.out.println(configurationErrorMessage);
        }
    }

    private static void configureDefaultGC() {
        if (Selenium.chromeDriverWasConfigured()) {
            System.setProperty("webdriver.chrome.driver", ChromeDriver_Path);
            if (DownloadSaveFilePath == "default") {
                driver = new ChromeDriver();
            } else {
                HashMap<String, Object> chromePrefs = new HashMap<String, Object>();
                chromePrefs.put("profile.default_content_settings.popups", 0);
                chromePrefs.put("download.default_directory", DownloadSaveFilePath);
                ChromeOptions options = new ChromeOptions();
                options.setExperimentalOption("prefs", chromePrefs);
                DesiredCapabilities cap = DesiredCapabilities.chrome();
                cap.setCapability("acceptSslCerts", true);
                cap.setCapability("chromeOptions", (Object)options);
                driver = new ChromeDriver((Capabilities)cap);
            }
        } else {
            System.out.println(configurationErrorMessage);
        }
    }

    private static void configureIE(DesiredCapabilities capabilities) throws MalformedURLException {
        capabilities.setBrowserName("internet explorer");
        capabilities.setCapability("ignoreProtectedModeSettings", true);
        driver = new RemoteWebDriver(new URL(SeleniumGridMachine), (Capabilities)capabilities);
    }

    private static void configureChrome() throws MalformedURLException {
        driver = new RemoteWebDriver(new URL(SeleniumGridMachine), (Capabilities)DesiredCapabilities.chrome());
    }

    private static void configureFirefox(DesiredCapabilities capabilities) throws MalformedURLException {
        capabilities.setBrowserName("firefox");
        driver = new RemoteWebDriver(new URL(SeleniumGridMachine), (Capabilities)capabilities);
    }

    private static void configuraSeleniumGridWithDocker() throws MalformedURLException {
        DesiredCapabilities chromeCapabilities = DesiredCapabilities.chrome();
        driver = new RemoteWebDriver(new URL(SeleniumGridDocker), (Capabilities)chromeCapabilities);
    }

    private static void configurePhantomJS(DesiredCapabilities capabilities) throws MalformedURLException {
        if (Selenium.phantomJSWasConfigured()) {
            capabilities.setBrowserName("PhantomJS");
            capabilities.setCapability("phantomjs.binary.path", PhantomJS_Path);
            driver = new PhantomJSDriver((Capabilities)capabilities);
        } else {
            System.out.println(configurationErrorMessage);
        }
    }

    private static void configureDefaultGCHeadless() {
        if (Selenium.chromeDriverWasConfigured()) {
            ChromeOptions chromeOptions = new ChromeOptions();
            System.setProperty("webdriver.chrome.driver", ChromeDriver_Path);
            chromeOptions.addArguments(new String[]{"--headless"});
            driver = new ChromeDriver(chromeOptions);
        } else {
            System.out.println(configurationErrorMessage);
        }
    }

    public static void quit() {
        driver.quit();
        driver = null;
    }

    private static boolean geckoDriverWasConfigured() {
        File genckoDriverFile = new File(GeckoDriver_Path);
        if (genckoDriverFile.exists() && genckoDriverFile.canExecute()) {
            configurationErrorMessage = "The geckodriver was configured correctly";
            return true;
        }
        configurationErrorMessage = "The geckodriver should be configured in '" + GeckoDriver_Path + "' according the project wiki.";
        return false;
    }

    private static boolean chromeDriverWasConfigured() {
        File chromeDriverFile = new File(ChromeDriver_Path);
        if (chromeDriverFile.exists() && chromeDriverFile.canExecute()) {
            configurationErrorMessage = "The chromedriver was configured correctly";
            return true;
        }
        configurationErrorMessage = "The chromedriver should be configured in '" + ChromeDriver_Path + "' according the project wiki.";
        return false;
    }

    private static boolean phantomJSWasConfigured() {
        File phantomJSDriverFile = new File(PhantomJS_Path);
        if (phantomJSDriverFile.exists() && phantomJSDriverFile.canExecute()) {
            configurationErrorMessage = "The phantomJS was configured correctly";
            return true;
        }
        configurationErrorMessage = "The phantomJS should be configured in '" + PhantomJS_Path + "' according the project wiki.";
        return false;
    }

    private static boolean defaultPropertiesFilePathWasConfigured() {
        File defaultPropertiesFile = new File(SeleniumReadPropertyKeys.getSeleniumPropertyKeysFilePath());
        if (defaultPropertiesFile.exists() && defaultPropertiesFile.canRead()) {
            configurationErrorMessage = "The defaultProperties.properties file was configured correctly";
            return true;
        }
        configurationErrorMessage = "The defaultProperties.properties should be configured in '" + SeleniumReadPropertyKeys.getSeleniumPropertyKeysFilePath() + "' according the project wiki.";
        return false;
    }
}

