/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.faces.test.selenium.browser.internal;

import com.liferay.faces.test.selenium.browser.BrowserDriver;
import com.liferay.faces.test.selenium.browser.BrowserDriverFactory;
import com.liferay.faces.test.selenium.browser.TestUtil;
import com.liferay.faces.test.selenium.browser.internal.BrowserDriverImpl;
import com.liferay.faces.test.selenium.browser.internal.HtmlUnitDriverLiferayFacesImpl;
import com.machinepublishers.jbrowserdriver.JBrowserDriver;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.chrome.ChromeDriver;
import org.openqa.selenium.chrome.ChromeOptions;
import org.openqa.selenium.firefox.FirefoxDriver;
import org.openqa.selenium.firefox.FirefoxProfile;
import org.openqa.selenium.phantomjs.PhantomJSDriver;
import org.openqa.selenium.remote.DesiredCapabilities;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BrowserDriverFactoryImpl
extends BrowserDriverFactory {
    private static final Logger logger = LoggerFactory.getLogger(BrowserDriverFactoryImpl.class);
    private static final String IPHONE_7_IOS_10_0_USER_AGENT = "Mozilla/5.0 (iPhone; CPU iPhone OS 10_0 like Mac OS X) AppleWebKit/602.1.38 (KHTML, like Gecko) Version/10.0 Mobile/14A5297c Safari/602.1";
    private static final boolean RUNNING_WITH_MAVEN = Boolean.valueOf(TestUtil.getSystemPropertyOrDefault("RUNNING_WITH_MAVEN", "false"));

    @Override
    public BrowserDriver getBrowserDriverImplementation() {
        String browserName = TestUtil.getSystemPropertyOrDefault("integration.browser.name", "chrome");
        String defaultBrowserHeadlessString = "true";
        if ("firefox".equals(browserName) || "chrome".equals(browserName) && !RUNNING_WITH_MAVEN) {
            defaultBrowserHeadlessString = "false";
        }
        String browserHeadlessString = TestUtil.getSystemPropertyOrDefault("integration.browser.headless", defaultBrowserHeadlessString);
        boolean browserHeadless = Boolean.parseBoolean(browserHeadlessString);
        String browserSimulatingMobileString = TestUtil.getSystemPropertyOrDefault("integration.browser.simulate.mobile", "false");
        boolean browserSimulatingMobile = Boolean.parseBoolean(browserSimulatingMobileString);
        return this.getBrowserDriverImplementation(browserName, browserHeadless, browserSimulatingMobile);
    }

    @Override
    public BrowserDriver getBrowserDriverImplementation(String browserName, boolean browserHeadless, boolean browserSimulateMobile) {
        HtmlUnitDriverLiferayFacesImpl webDriver;
        if ("chrome".equals(browserName)) {
            ChromeOptions chromeOptions = new ChromeOptions();
            String chromeBinaryPath = TestUtil.getSystemPropertyOrDefault("webdriver.chrome.bin", null);
            if (chromeBinaryPath != null) {
                chromeOptions.setBinary(chromeBinaryPath);
                logger.info("Chrome Binary: {}", (Object)chromeBinaryPath);
            }
            if (browserHeadless) {
                chromeOptions.addArguments(new String[]{"headless", "disable-gpu", "window-size=1920,1200"});
            } else {
                chromeOptions.addArguments(new String[]{"start-maximized"});
            }
            if (browserSimulateMobile) {
                chromeOptions.addArguments(new String[]{"user-agent=\"Mozilla/5.0 (iPhone; CPU iPhone OS 10_0 like Mac OS X) AppleWebKit/602.1.38 (KHTML, like Gecko) Version/10.0 Mobile/14A5297c Safari/602.1\""});
            }
            webDriver = new ChromeDriver(chromeOptions);
        } else if ("firefox".equals(browserName)) {
            String firefoxBinaryPath = TestUtil.getSystemPropertyOrDefault("webdriver.firefox.bin", null);
            if (firefoxBinaryPath != null) {
                logger.info("Firefox Binary: {}", (Object)firefoxBinaryPath);
            }
            FirefoxProfile firefoxProfile = new FirefoxProfile();
            firefoxProfile.setPreference("webdriver_firefox_allowed_hosts", System.getenv("HOSTNAME") + ",localhost");
            if (browserHeadless) {
                throw new UnsupportedOperationException("Headless mode is not yet supported for Firefox");
            }
            if (browserSimulateMobile) {
                firefoxProfile.setPreference("general.useragent.override", IPHONE_7_IOS_10_0_USER_AGENT);
            }
            webDriver = new FirefoxDriver(firefoxProfile);
        } else if ("phantomjs".equals(browserName)) {
            String phantomJSBinaryPath = TestUtil.getSystemPropertyOrDefault("phantomjs.binary.path", null);
            if (phantomJSBinaryPath != null) {
                logger.info("PhantomJS Binary: {}", (Object)phantomJSBinaryPath);
            }
            DesiredCapabilities desiredCapabilities = new DesiredCapabilities();
            if (!browserHeadless) {
                throw new UnsupportedOperationException("Non-headless mode is not yet supported for PhantomJS");
            }
            if (browserSimulateMobile) {
                desiredCapabilities.setCapability("phantomjs.page.settings.userAgent", IPHONE_7_IOS_10_0_USER_AGENT);
                desiredCapabilities.setCapability("phantomjs.page.customHeaders.User-Agent", IPHONE_7_IOS_10_0_USER_AGENT);
            }
            desiredCapabilities.setCapability("phantomjs.page.customHeaders.Accept-Language", "en-US,en;q=0.8");
            String phantomJSLogLevel = logger.isDebugEnabled() ? "DEBUG" : (logger.isInfoEnabled() ? "INFO" : (logger.isWarnEnabled() ? "WARN" : (logger.isErrorEnabled() ? "ERROR" : "NONE")));
            String[] phantomArgs = new String[]{"--webdriver-loglevel=" + phantomJSLogLevel};
            desiredCapabilities.setCapability("phantomjs.cli.args", (Object)phantomArgs);
            webDriver = new PhantomJSDriver((Capabilities)desiredCapabilities);
        } else if ("htmlunit".equals(browserName)) {
            if (!browserHeadless) {
                throw new UnsupportedOperationException("Non-headless mode is not yet supported for HtmlUnit");
            }
            webDriver = browserSimulateMobile ? new HtmlUnitDriverLiferayFacesImpl(IPHONE_7_IOS_10_0_USER_AGENT) : new HtmlUnitDriverLiferayFacesImpl();
        } else if ("jbrowser".equals(browserName)) {
            if (!browserHeadless) {
                throw new UnsupportedOperationException("Non-headless mode is not yet supported for JBrowser");
            }
            if (browserSimulateMobile) {
                throw new UnsupportedOperationException("Mobile simulation is not yet supported for JBrowser.");
            }
            webDriver = new JBrowserDriver();
        } else {
            throw new UnsupportedOperationException("Browser with not supported: " + browserName);
        }
        if (!"chrome".equals(browserName)) {
            webDriver.manage().window().maximize();
        }
        return this.getBrowserDriverImplementation((WebDriver)webDriver, browserHeadless, browserSimulateMobile);
    }

    @Override
    public BrowserDriver getBrowserDriverImplementation(WebDriver webDriver, boolean browserHeadless, boolean browserSimulateMobile) {
        return new BrowserDriverImpl(webDriver, browserHeadless, browserSimulateMobile);
    }
}

