/**
 * Copyright (c) 2000-2019 Liferay, Inc. All rights reserved.
 *
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
 * details.
 */
package com.liferay.faces.lsv_485.patch.renderkit.richfaces;

import java.io.IOException;

import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.render.Renderer;

import com.liferay.faces.lsv_485.patch.renderkit.RendererWrapper;


/**
 * @author  Kyle Stiemann
 */
public final class FileUploadRendererRichFacesImpl extends RendererWrapper {

	// Private Final Data Members
	private final Renderer wrappedRenderer;

	public FileUploadRendererRichFacesImpl(Renderer wrappedRenderer) {
		this.wrappedRenderer = wrappedRenderer;
	}

	@Override
	public void decode(FacesContext originalFacesContext, UIComponent uiComponent) {

		FacesContext facesContext = new FacesContextFACES_2638WorkaroundImpl(originalFacesContext);

		try {

			FacesContextUtil.setCurrentFacesContextInstance(facesContext);
			super.decode(facesContext, uiComponent);
		}
		finally {
			FacesContextUtil.setCurrentFacesContextInstance(originalFacesContext);
		}
	}

	@Override
	public void encodeEnd(FacesContext originalFacesContext, UIComponent uiComponent) throws IOException {

		FacesContext facesContext = new FacesContextFACES_2638WorkaroundImpl(originalFacesContext);

		try {

			FacesContextUtil.setCurrentFacesContextInstance(facesContext);
			super.encodeEnd(facesContext, uiComponent);
		}
		finally {
			FacesContextUtil.setCurrentFacesContextInstance(originalFacesContext);
		}
	}

	@Override
	public Renderer getWrapped() {
		return wrappedRenderer;
	}

	private static final class FacesContextUtil extends FacesContextUnsupportedImpl {

		private FacesContextUtil() {
			throw new AssertionError();
		}

		public static void setCurrentFacesContextInstance(FacesContext facesContext) {
			setCurrentInstance(facesContext);
		}
	}
}
