/**
 * Copyright (c) 2000-2019 Liferay, Inc. All rights reserved.
 *
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
 * details.
 */
package com.liferay.faces.lsv_485.patch.renderkit.richfaces;

import javax.faces.context.ExternalContext;
import javax.faces.context.ExternalContextWrapper;
import javax.faces.context.FacesContext;
import javax.faces.context.FacesContextWrapper;
import javax.portlet.PortletContext;
import javax.servlet.ServletRequest;

import com.liferay.faces.lsv_485.patch.renderkit.HttpServletRequestFileUploadAdapter;
import com.liferay.faces.lsv_485.patch.renderkit.ServletContextFileUploadAdapterImpl;


/**
 * @author  Kyle Stiemann
 */
/* package-private */ final class FacesContextFACES_2638WorkaroundImpl extends FacesContextWrapper {

	// Private Data Members
	private ExternalContext externalContext;
	private FacesContext wrappedFacesContext;

	public FacesContextFACES_2638WorkaroundImpl(FacesContext wrappedFacesContext) {

		ExternalContext wrappedExternalContext = wrappedFacesContext.getExternalContext();
		this.externalContext = new ExternalContextFACES_2638WorkaroundImpl(wrappedExternalContext);
		this.wrappedFacesContext = wrappedFacesContext;
	}

	@Override
	public ExternalContext getExternalContext() {
		return externalContext;
	}

	@Override
	public FacesContext getWrapped() {
		return wrappedFacesContext;
	}

	@Override
	public void release() {

		super.release();
		wrappedFacesContext = null;
		externalContext = null;
	}

	private static final class ExternalContextFACES_2638WorkaroundImpl extends ExternalContextWrapper {

		// Private Data Members
		private final ExternalContext wrappedExternalContext;
		private final Object context;

		public ExternalContextFACES_2638WorkaroundImpl(ExternalContext wrappedExternalContext) {

			Object request = wrappedExternalContext.getRequest();

			if (request instanceof HttpServletRequestFileUploadAdapter) {

				ServletRequest servletRequest = (ServletRequest) request;
				this.context = servletRequest.getServletContext();
			}
			else {

				PortletContext portletContext = (PortletContext) wrappedExternalContext.getContext();
				this.context = new ServletContextFileUploadAdapterImpl(portletContext);
			}

			this.wrappedExternalContext = wrappedExternalContext;
		}

		@Override
		public Object getContext() {
			return context;
		}

		@Override
		public ExternalContext getWrapped() {
			return wrappedExternalContext;
		}
	}
}
