/**
 * Copyright (c) 2000-2019 Liferay, Inc. All rights reserved.
 *
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
 * details.
 */
package com.liferay.faces.lsv_485.patch.renderkit;

import java.util.Iterator;

import javax.faces.FacesWrapper;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.faces.render.RenderKit;
import javax.faces.render.RenderKitFactory;
import javax.faces.render.RenderKitWrapper;
import javax.faces.render.Renderer;

import com.liferay.faces.lsv_485.patch.renderkit.richfaces.FileUploadRendererRichFacesImpl;


/**
 * @author  Kyle Stiemann
 */
public final class RenderKitFactoryLSV_485Impl extends RenderKitFactory implements FacesWrapper<RenderKitFactory> {

	// Private Final Data Members
	private final RenderKitFactory wrappedRenderKitFactory;
	private final boolean jsf22;
	private final Class<?> contextMapFactoryClass;
	private final boolean liferayFacesLegacy;

	public RenderKitFactoryLSV_485Impl(RenderKitFactory wrappedRenderKitFactory) {

		this.wrappedRenderKitFactory = wrappedRenderKitFactory;
		this.contextMapFactoryClass = ClassLoaderUtil.loadClass(
				"com.liferay.faces.bridge.context.map.internal.ContextMapFactory");
		this.jsf22 = ClassLoaderUtil.loadClass("javax.faces.flow.Flow") != null;

		if (contextMapFactoryClass == null) {
			throw new RuntimeException(new ClassNotFoundException(
					"com.liferay.faces.bridge.context.map.internal.ContextMapFactory not found."));
		}

		this.liferayFacesLegacy = ClassLoaderUtil.loadClass("com.liferay.faces.bridge.context.BridgeContext") != null;
	}

	private static boolean isStartupOrShutdown(FacesContext facesContext) {

		Object request = null;

		try {

			if (facesContext != null) {

				ExternalContext externalContext = facesContext.getExternalContext();

				if (externalContext != null) {
					request = externalContext.getRequest();
				}
			}
		}
		catch (UnsupportedOperationException e) {
			// do nothing
		}

		return (request == null);
	}

	@Override
	public void addRenderKit(String renderKitId, RenderKit renderKit) {
		wrappedRenderKitFactory.addRenderKit(renderKitId, renderKit);
	}

	@Override
	public RenderKit getRenderKit(FacesContext facesContext, String renderKitId) {

		RenderKit renderKit = wrappedRenderKitFactory.getRenderKit(facesContext, renderKitId);

		if (("HTML_BASIC".equals(renderKitId) || "PRIMEFACES_MOBILE".equals(renderKitId)) &&
				!isStartupOrShutdown(facesContext)) {
			renderKit = new RenderKitLSV_485Impl(renderKit, jsf22, contextMapFactoryClass, liferayFacesLegacy);
		}

		return renderKit;
	}

	@Override
	public Iterator<String> getRenderKitIds() {
		return wrappedRenderKitFactory.getRenderKitIds();
	}

	@Override
	public RenderKitFactory getWrapped() {
		return wrappedRenderKitFactory;
	}

	private static final class RenderKitLSV_485Impl extends RenderKitWrapper {

		// Private Final Data Members
		private final RenderKit wrappedRenderKit;
		private final boolean jsf22;
		private final Class<?> contextMapFactoryClass;
		private final boolean liferayFacesLegacy;

		public RenderKitLSV_485Impl(RenderKit wrappedRenderKit, boolean jsf22, Class<?> contextMapFactoryClass,
			boolean liferayFacesLegacy) {

			this.wrappedRenderKit = wrappedRenderKit;
			this.jsf22 = jsf22;
			this.contextMapFactoryClass = contextMapFactoryClass;
			this.liferayFacesLegacy = liferayFacesLegacy;
		}

		private static Renderer unwrapLiferayFacesRenderer(Renderer renderer) {

			while ((renderer != null) && (renderer instanceof FacesWrapper) &&
					renderer.getClass().getName().startsWith("com.liferay.faces")) {

				FacesWrapper<Renderer> rendererWrapper = (FacesWrapper<Renderer>) renderer;
				renderer = rendererWrapper.getWrapped();
			}

			return renderer;
		}

		@Override
		public Renderer getRenderer(String family, String rendererType) {

			Renderer renderer = super.getRenderer(family, rendererType);

			// PrimeFaces p:fileUpload fix. See: https://issues.liferay.com/browse/FACES-3391
			if ("org.primefaces.component".equals(family) &&
					"org.primefaces.component.FileUploadRenderer".equals(rendererType)) {

				// The vulnerability for p:fileUpload only exists in PrimeFaces 6.2+ and PrimeFaces 6.2+ is only
				// supported with Liferay Faces Bridge 4.1.2+ (which only supports JSF 2.2). All other versions should
				// delegate to the provided renderer.
				if (jsf22) {
					renderer = unwrapLiferayFacesRenderer(renderer);
					renderer = new FileUploadRendererPortletImpl(renderer, contextMapFactoryClass, liferayFacesLegacy);
				}
			}

			// RichFaces rich:fileUpload fix. See: https://issues.liferay.com/browse/FACES-3392
			else if ("org.richfaces.FileUpload".equals(family) &&
					"org.richfaces.FileUploadRenderer".equals(rendererType)) {

				renderer = unwrapLiferayFacesRenderer(renderer);
				renderer = new FileUploadRendererRichFacesImpl(renderer);
				renderer = new FileUploadRendererPortletImpl(renderer, contextMapFactoryClass, liferayFacesLegacy);
			}
			else {
				renderer = super.getRenderer(family, rendererType);
			}

			return renderer;
		}

		@Override
		public RenderKit getWrapped() {
			return wrappedRenderKit;
		}
	}
}
