/**
 * Copyright (c) 2000-2019 Liferay, Inc. All rights reserved.
 *
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
 * details.
 */
package com.liferay.faces.lsv_485.patch.renderkit;

/**
 * @author  Kyle Stiemann
 */
/* package-private */ final class ClassLoaderUtil {

	private ClassLoaderUtil() {
		throw new AssertionError();
	}

	public static Class<?> loadClass(String className) {

		Class<?> clazz = null;

		try {

			ClassLoader classLoader = Thread.currentThread().getContextClassLoader();

			if (classLoader == null) {
				classLoader = ClassLoaderUtil.class.getClassLoader();
			}

			clazz = classLoader.loadClass(className);
		}
		catch (ClassNotFoundException e) {
			// Do nothing.
		}

		return clazz;
	}
}
