/**
 * Copyright (c) 2000-2019 Liferay, Inc. All rights reserved.
 *
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
 * details.
 */
package com.liferay.faces.lsv_485.patch.context;

import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Enumeration;
import java.util.Set;
import javax.faces.FacesWrapper;
import javax.portlet.PortletContext;
import javax.portlet.PortletRequestDispatcher;

/**
 * @author Kyle Stiemann
 */
/* package-private */ final class PortletContextLSV_485Impl implements PortletContext, FacesWrapper<PortletContext> {

	// Private Final Data Members
	private final InitParams initParams;
	private final PortletContext wrappedPortletContext;

	public PortletContextLSV_485Impl(PortletContext wrappedPortletContext) {

		this.initParams = new InitParams(wrappedPortletContext);
		this.wrappedPortletContext = wrappedPortletContext;
	}

	@Override
	public String getServerInfo() {
		return getWrapped().getServerInfo();
	}

	@Override
	public PortletRequestDispatcher getRequestDispatcher(String path) {
		return getWrapped().getRequestDispatcher(path);
	}

	@Override
	public PortletRequestDispatcher getNamedDispatcher(String name) {
		return getWrapped().getNamedDispatcher(name);
	}

	@Override
	public InputStream getResourceAsStream(String path) {
		return getWrapped().getResourceAsStream(path);
	}

	@Override
	public int getMajorVersion() {
		return getWrapped().getMajorVersion();
	}

	@Override
	public int getMinorVersion() {
		return getWrapped().getMinorVersion();
	}

	@Override
	public String getMimeType(String file) {
		return getWrapped().getMimeType(file);
	}

	@Override
	public String getRealPath(String path) {
		return getWrapped().getRealPath(path);
	}

	@Override
	public Set<String> getResourcePaths(String path) {
		return getWrapped().getResourcePaths(path);
	}

	@Override
	public URL getResource(String path) throws MalformedURLException {
		return getWrapped().getResource(path);
	}

	@Override
	public Object getAttribute(String name) {
		return getWrapped().getAttribute(name);
	}

	@Override
	public Enumeration<String> getAttributeNames() {
		return getWrapped().getAttributeNames();
	}

	@Override
	public String getInitParameter(String name) {
		return initParams.getInitParameter(name, getWrapped());
	}

	@Override
	public Enumeration<String> getInitParameterNames() {
		return initParams.getInitParameterNames(getWrapped());
	}

	@Override
	public void log(String msg) {
		getWrapped().log(msg);
	}

	@Override
	public void log(String message, Throwable throwable) {
		getWrapped().log(message, throwable);
	}

	@Override
	public void removeAttribute(String name) {
		getWrapped().removeAttribute(name);
	}

	@Override
	public void setAttribute(String name, Object object) {
		getWrapped().setAttribute(name, object);
	}

	@Override
	public String getPortletContextName() {
		return getWrapped().getPortletContextName();
	}

	@Override
	public Enumeration<String> getContainerRuntimeOptions() {
		return getWrapped().getContainerRuntimeOptions();
	}

	@Override
	public PortletContext getWrapped() {
		return wrappedPortletContext;
	}
}
