/**
 * Copyright (c) 2000-2019 Liferay, Inc. All rights reserved.
 *
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
 * details.
 */
package com.liferay.faces.lsv_485.patch.context;

import java.util.Enumeration;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import javax.faces.FacesWrapper;
import javax.portlet.PortletConfig;
import javax.portlet.PortletContext;
import javax.xml.namespace.QName;

/**
 * @author Kyle Stiemann
 */
/* package-private */ class PortletConfigLSV_485Impl implements PortletConfig, FacesWrapper<PortletConfig> {

	// Private Final Data Members
	private final InitParams initParams;
	private final PortletConfig wrappedPortletConfig;
	private final PortletContext portletContext;

	public PortletConfigLSV_485Impl(PortletConfig wrappedPortletConfig, PortletContext portletContext) {

		this.initParams = new InitParams(wrappedPortletConfig);
		this.wrappedPortletConfig = wrappedPortletConfig;
		this.portletContext = portletContext;
	}

	@Override
	public Map<String, String[]> getContainerRuntimeOptions() {
		return getWrapped().getContainerRuntimeOptions();
	}

	@Override
	public String getDefaultNamespace() {
		return getWrapped().getDefaultNamespace();
	}

	@Override
	public String getInitParameter(String name) {
		return initParams.getInitParameter(name, getWrapped());
	}

	@Override
	public Enumeration<String> getInitParameterNames() {
		return initParams.getInitParameterNames(getWrapped());
	}

	@Override
	public PortletContext getPortletContext() {
		return portletContext;
	}

	@Override
	public String getPortletName() {
		return getWrapped().getPortletName();
	}

	@Override
	public Enumeration<QName> getProcessingEventQNames() {
		return getWrapped().getProcessingEventQNames();
	}

	@Override
	public Enumeration<String> getPublicRenderParameterNames() {
		return getWrapped().getPublicRenderParameterNames();
	}

	@Override
	public Enumeration<QName> getPublishingEventQNames() {
		return getWrapped().getPublishingEventQNames();
	}

	@Override
	public ResourceBundle getResourceBundle(Locale locale) {
		return getWrapped().getResourceBundle(locale);
	}

	@Override
	public Enumeration<Locale> getSupportedLocales() {
		return getWrapped().getSupportedLocales();
	}

	@Override
	public PortletConfig getWrapped() {
		return wrappedPortletConfig;
	}
}
