/**
 * Copyright (c) 2000-2019 Liferay, Inc. All rights reserved.
 *
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
 * details.
 */
package com.liferay.faces.lsv_485.patch.context;

import com.liferay.faces.util.config.WebConfigParam;
import com.liferay.faces.util.logging.Logger;
import com.liferay.faces.util.logging.LoggerFactory;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;
import javax.portlet.PortletConfig;
import javax.portlet.PortletContext;

/**
 * @author Kyle Stiemann
 */
/* package-private */ final class InitParams {

	// Logger
	private static final Logger logger = LoggerFactory.getLogger(InitParams.class);

	// Package-Private Constants
	/* package-private */ static final String BRIDGE_UPLOADED_FILE_MAX_SIZE_PARAM_NAME =
		"com.liferay.faces.bridge.uploadedFileMaxSize";
	/* package-private */ static final String BRIDGE_UPLOADED_FILES_DIR_PARAM_NAME =
		"com.liferay.faces.bridge.uploadedFilesDir";

	// Private Final Data Members
	private final String uploadedFileMaxSize;
	private final String uploadedFilesDir;
	private final Enumeration<String> initParameterNames;

	public InitParams(Object portletInitParamHolder) {

		this.uploadedFileMaxSize = getUtilParamValue(portletInitParamHolder,
			WebConfigParam.UploadedFileMaxSize.getName(), BRIDGE_UPLOADED_FILE_MAX_SIZE_PARAM_NAME);
		this.uploadedFilesDir = getUtilParamValue(portletInitParamHolder, WebConfigParam.UploadedFilesDir.getName(),
			BRIDGE_UPLOADED_FILES_DIR_PARAM_NAME);

		if ((uploadedFileMaxSize != null) || (uploadedFilesDir != null)) {

			Set<String> initParameterNames = new HashSet<String>(Collections.list(getInitParamNames(
				portletInitParamHolder)));

			if (uploadedFileMaxSize != null) {
				initParameterNames.add(BRIDGE_UPLOADED_FILE_MAX_SIZE_PARAM_NAME);
			}

			if (uploadedFilesDir != null) {
				initParameterNames.add(BRIDGE_UPLOADED_FILES_DIR_PARAM_NAME);
			}

			this.initParameterNames = Collections.enumeration(initParameterNames);
		}
		else {
			this.initParameterNames = null;
		}
	}

	private static Enumeration<String> getInitParamNames(Object portletInitParamHolder) {

		if (portletInitParamHolder instanceof PortletContext) {
			return ((PortletContext)portletInitParamHolder).getInitParameterNames();
		}
		else if (portletInitParamHolder instanceof PortletConfig) {
			return ((PortletConfig)portletInitParamHolder).getInitParameterNames();
		}
		else {
			throw new UnsupportedOperationException();
		}
	}

	private static String getInitParam(Object portletInitParamHolder, String paramName) {

		if (portletInitParamHolder instanceof PortletContext) {
			return ((PortletContext)portletInitParamHolder).getInitParameter(paramName);
		}
		else if (portletInitParamHolder instanceof PortletConfig) {
			return ((PortletConfig)portletInitParamHolder).getInitParameter(paramName);
		}
		else {
			throw new UnsupportedOperationException();
		}
	}

	private static String getUtilParamValue(Object portletInitParamHolder, String utilParamName,
		String bridgeParamName) {

		String utilParamValue = getInitParam(portletInitParamHolder, utilParamName);

		if (utilParamValue != null) {

			String bridgeParamValue = getInitParam(portletInitParamHolder, bridgeParamName);

			if (bridgeParamValue != null) {
				logger.info(
					"Both {0} and {1} context parameters are set in WEB-INF/web.xml. The value of {0} ({2}) will be ignored and the value of {1} ({3}) will be used.",
					bridgeParamName, utilParamName, bridgeParamValue, utilParamValue);
			}
		}

		return utilParamValue;
	}

	public String getInitParameter(String name, Object portletInitParamHolder) {

		if ((uploadedFileMaxSize != null) &&
				(WebConfigParam.UploadedFileMaxSize.getName().equals(name) ||
					BRIDGE_UPLOADED_FILE_MAX_SIZE_PARAM_NAME.equals(name))) {
			return uploadedFileMaxSize;
		}
		else if ((uploadedFilesDir != null) &&
				(WebConfigParam.UploadedFilesDir.getName().equals(name) ||
					BRIDGE_UPLOADED_FILES_DIR_PARAM_NAME.equals(name))) {
			return uploadedFilesDir;
		}
		else {
			return getInitParam(portletInitParamHolder, name);
		}
	}

	public Enumeration<String> getInitParameterNames(Object portletInitParamHolder) {

		if (initParameterNames != null) {
			return initParameterNames;
		}
		else {
			return getInitParamNames(portletInitParamHolder);
		}
	}
}
