/**
 * Copyright (c) 2000-2019 Liferay, Inc. All rights reserved.
 *
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
 * details.
 */
package com.liferay.faces.lsv_485.patch.context;

import com.liferay.faces.util.config.WebConfigParam;
import java.util.Map;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import org.icefaces.ace.component.fileentry.FileEntry;

/**
 *
 * @author Kyle Stiemann
 */
public class FileEntryLSV_485Impl extends FileEntry {

	// Private Constants
	private static final AttributeGetter<Long> MAX_FILE_SIZE_GETTER = new AttributeGetterMaxFileSizeImpl();
	private static final AttributeGetter<String> ABSOLUTE_PATH_GETTER = new AttributeGetterAbsolutePathImpl();

	@Override
	public long getMaxFileSize() {
		return MAX_FILE_SIZE_GETTER.getAttribute(this);
	}

	@Override
	public String getAbsolutePath() {
		return ABSOLUTE_PATH_GETTER.getAttribute(this);
	}

	private String getInitParamValue(WebConfigParam webConfigParam,	String... initParamNames) {

		String returnValue = webConfigParam.getDefaultStringValue();

		for (String initParamName : initParamNames) {

			FacesContext facesContext = getFacesContext();
			ExternalContext externalContext = facesContext.getExternalContext();
			String initParamValue = externalContext.getInitParameter(initParamName);

			if (initParamValue != null) {

				returnValue = initParamValue;
				break;
			}
		}

		return returnValue;
	}

	private String getOriginalAbsolutePath() {
		return super.getAbsolutePath();
	}

	private long getOriginalMaxFileSize() {
		return super.getMaxFileSize();
	}

	/**
	 * Subclasses of this class must be stateless/thread-safe.
	 * @param <T>
	 */
	private static abstract class AttributeGetter<T> {

		/* package-private */ final T getAttribute(FileEntryLSV_485Impl fileEntryLSV_485Impl, String lsvAttrName,
			WebConfigParam webConfigParam, String... initParamNames) {

			Map<String, Object> attributes = fileEntryLSV_485Impl.getAttributes();
			T attr = (T) attributes.get(lsvAttrName);

			if (attr == null) {

				String initParamStringValue = fileEntryLSV_485Impl.getInitParamValue(webConfigParam, initParamNames);

				if (initParamStringValue == null) {
					attr = getOriginalAttribute(fileEntryLSV_485Impl);
				}
				else {

					attr = convertInitParamStringValueToAttribute(initParamStringValue);

					if (useOriginalAttribute(attr, fileEntryLSV_485Impl)) {
						attr = getOriginalAttribute(fileEntryLSV_485Impl);
					}
				}
			}

			return attr;
		}

		/* package-private */ abstract T convertInitParamStringValueToAttribute(String initParamValue);
		/* package-private */ abstract T getOriginalAttribute(FileEntryLSV_485Impl fileEntryLSV_485Impl);

		/**
		 * @param attr guaranteed to be non-null by the time this method is called.
		 * @param fileEntryLSV_485Impl
		 * @return
		 */
		/* package-private */ abstract boolean useOriginalAttribute(T attr, FileEntryLSV_485Impl fileEntryLSV_485Impl);

		public abstract T getAttribute(FileEntryLSV_485Impl fileEntryLSV_485Impl);
	}

	private static final class AttributeGetterMaxFileSizeImpl extends AttributeGetter<Long> {

		// Private Constants
		private static final String JSF_UPLOADED_FILE_MAX_SIZE = "javax.faces.UPLOADED_FILE_MAX_SIZE";
		private static final String LSV_MAX_FILE_SIZE_ATTR_NAME =
			AttributeGetterMaxFileSizeImpl.class.getName() + ".maxFileSize";

		@Override
		/* package-private */ Long convertInitParamStringValueToAttribute(String initParamValue) {
			return Long.parseLong(initParamValue);
		}

		@Override
		/* package-private */ Long getOriginalAttribute(FileEntryLSV_485Impl fileEntryLSV_485Impl) {
			return fileEntryLSV_485Impl.getOriginalMaxFileSize();
		}

		@Override
		/* package-private */ boolean useOriginalAttribute(Long attr, FileEntryLSV_485Impl fileEntryLSV_485Impl) {
			return attr > fileEntryLSV_485Impl.getOriginalMaxFileSize();
		}

		@Override
		public Long getAttribute(FileEntryLSV_485Impl fileEntryLSV_485Impl) {
			return getAttribute(fileEntryLSV_485Impl, LSV_MAX_FILE_SIZE_ATTR_NAME, WebConfigParam.UploadedFileMaxSize,
				WebConfigParam.UploadedFileMaxSize.getName(), InitParams.BRIDGE_UPLOADED_FILE_MAX_SIZE_PARAM_NAME,
				JSF_UPLOADED_FILE_MAX_SIZE);
		}
	}

	private static final class AttributeGetterAbsolutePathImpl extends AttributeGetter<String> {

		// Private Constants
		private static final String JSF_UPLOADED_FILES_DIR = "javax.faces.UPLOADED_FILES_DIR";
		private static final String LSV_ABSOLUTE_PATH_ATTR_NAME =
			AttributeGetterMaxFileSizeImpl.class.getName() + ".absolutePath";

		@Override
		/* package-private */ String convertInitParamStringValueToAttribute(String initParamValue) {
			return initParamValue;
		}

		@Override
		/* package-private */ String getOriginalAttribute(FileEntryLSV_485Impl fileEntryLSV_485Impl) {
			return fileEntryLSV_485Impl.getOriginalAbsolutePath();
		}

		@Override
		/* package-private */ boolean useOriginalAttribute(String attr, FileEntryLSV_485Impl fileEntryLSV_485Impl) {
			return true;
		}

		@Override
		public String getAttribute(FileEntryLSV_485Impl fileEntryLSV_485Impl) {
			return getAttribute(fileEntryLSV_485Impl, LSV_ABSOLUTE_PATH_ATTR_NAME, WebConfigParam.UploadedFilesDir,
				WebConfigParam.UploadedFilesDir.getName(), InitParams.BRIDGE_UPLOADED_FILES_DIR_PARAM_NAME,
				JSF_UPLOADED_FILES_DIR);
		}
	}
}
