/**
 * Copyright (c) 2000-2019 Liferay, Inc. All rights reserved.
 *
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
 * details.
 */
package com.liferay.faces.lsv_485.patch.context;


import javax.faces.FacesException;
import javax.faces.context.ExternalContext;
import javax.faces.context.ExternalContextFactory;
import javax.portlet.PortletConfig;
import javax.portlet.PortletContext;
import javax.portlet.PortletRequest;


/**
 * @author  Kyle Stiemann
 */
public final class ExternalContextFactoryLSV_485Impl extends ExternalContextFactory {

	// Private Final Data Members
	private final ExternalContextFactory wrappedExternalContextFactory;

	public ExternalContextFactoryLSV_485Impl(ExternalContextFactory wrappedExternalContextFactory) {
		this.wrappedExternalContextFactory = wrappedExternalContextFactory;
	}

	@Override
	public ExternalContext getExternalContext(Object context, Object request, Object response) throws FacesException {

		if (context instanceof PortletContext) {

			PortletRequest portletRequest = (PortletRequest) request;
			PortletConfig portletConfig = (PortletConfig) portletRequest.getAttribute(PortletConfig.class.getName());

			if (portletConfig != null) {

				// Alloy alloy:inputFile fix. See: https://issues.liferay.com/browse/FACES-3393
				PortletContext portletContext = new PortletContextLSV_485Impl((PortletContext) context);
				portletRequest.setAttribute(PortletConfig.class.getName(), new PortletConfigLSV_485Impl(portletConfig,
					portletContext));
				context = portletContext;
			}
		}

		return wrappedExternalContextFactory.getExternalContext(context, request, response);
	}

	@Override
	public ExternalContextFactory getWrapped() {
		return wrappedExternalContextFactory;
	}
}
