/**
 * Copyright (c) 2000-2019 Liferay, Inc. All rights reserved.
 *
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
 * details.
 */
package com.liferay.faces.lsv_485.patch.context;

import com.liferay.faces.bridge.config.BridgeConfig;
import com.liferay.faces.bridge.context.BridgeContext;
import com.liferay.faces.bridge.context.BridgeContextFactory;
import com.liferay.faces.bridge.context.IncongruityContext;
import com.liferay.faces.bridge.scope.BridgeRequestScope;
import javax.portlet.PortletConfig;
import javax.portlet.PortletContext;
import javax.portlet.PortletRequest;
import javax.portlet.PortletResponse;
import javax.portlet.faces.Bridge;

/**
 *
 * @author Kyle Stiemann
 */
public final class BridgeContextFactoryLSV_485Impl extends BridgeContextFactory {

	// Private Final Data Members
	private final BridgeContextFactory wrappedBridgeContextFactory;

	public BridgeContextFactoryLSV_485Impl(BridgeContextFactory wrappedBridgeContextFactory) {
		this.wrappedBridgeContextFactory = wrappedBridgeContextFactory;
	}

	@Override
	public BridgeContext getBridgeContext(BridgeConfig bridgeConfig, BridgeRequestScope bridgeRequestScope,
		PortletConfig portletConfig, PortletContext portletContext, PortletRequest portletRequest,
		PortletResponse portletResponse, Bridge.PortletPhase portletPhase, IncongruityContext incongruityContext) {

		portletContext = new PortletContextLSV_485Impl(portletContext);
		portletConfig = new PortletConfigLSV_485Impl(portletConfig, portletContext);

		return wrappedBridgeContextFactory.getBridgeContext(bridgeConfig, bridgeRequestScope, portletConfig,
			portletContext, portletRequest, portletResponse, portletPhase, incongruityContext);
	}

	public BridgeContextFactory getWrapped() {
		return  wrappedBridgeContextFactory;
	}
}
