/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.faces.util.xml;

import java.util.ArrayList;
import java.util.List;
import org.xml.sax.Attributes;

public class AttributesImpl
implements Attributes {
    public static final String TYPE_CDATA = "CDATA";
    public static final String TYPE_ID = "ID";
    public static final String TYPE_IDREF = "IDREF";
    public static final String TYPE_IDREFS = "IDREFS";
    public static final String TYPE_NMTOKEN = "NMTOKEN";
    public static final String TYPE_NMTOKENS = "NMTOKENS";
    public static final String TYPE_ENTITY = "ENTITY";
    public static final String TYPE_ENTITIES = "ENTITIES";
    public static final String TYPE_NOTATION = "NOTATION";
    private List<Attribute> attributes = new ArrayList<Attribute>();

    public void add(String uri, String localName, String qName, String type, String value) {
        Attribute attribute = new Attribute(uri, localName, qName, type, value);
        this.attributes.add(attribute);
    }

    public int getIndex(String qName) {
        int index = -1;
        if (qName != null) {
            int length = this.attributes.size();
            for (int i = 0; i < length; ++i) {
                Attribute attribute = this.attributes.get(i);
                if (!qName.equals(attribute.qName)) continue;
                index = i;
                break;
            }
        }
        return index;
    }

    public int getIndex(String uri, String localName) {
        int index = -1;
        if (uri != null && localName != null) {
            int length = this.attributes.size();
            for (int i = 0; i < length; ++i) {
                Attribute attribute = this.attributes.get(i);
                if (!uri.equals(attribute.uri) || !localName.equals(attribute.localName)) continue;
                index = i;
                break;
            }
        }
        return index;
    }

    public int getLength() {
        return this.attributes.size();
    }

    public String getLocalName(int index) {
        return this.attributes.get((int)index).localName;
    }

    public String getQName(int index) {
        return this.attributes.get((int)index).qName;
    }

    public String getType(int index) {
        return this.attributes.get((int)index).type;
    }

    public String getType(String qName) {
        String type = null;
        if (qName != null) {
            int length = this.attributes.size();
            for (int i = 0; i < length; ++i) {
                Attribute attribute = this.attributes.get(i);
                if (!qName.equals(attribute.qName)) continue;
                type = attribute.type;
                break;
            }
        }
        return type;
    }

    public String getType(String uri, String localName) {
        String type = null;
        if (uri != null && localName != null) {
            int length = this.attributes.size();
            for (int i = 0; i < length; ++i) {
                Attribute attribute = this.attributes.get(i);
                if (!uri.equals(attribute.uri) || !localName.equals(attribute.localName)) continue;
                type = attribute.type;
                break;
            }
        }
        return type;
    }

    public String getURI(int index) {
        return this.attributes.get((int)index).uri;
    }

    public String getValue(int index) {
        return this.attributes.get((int)index).value;
    }

    public String getValue(String qName) {
        String value = null;
        if (qName != null) {
            int length = this.attributes.size();
            for (int i = 0; i < length; ++i) {
                Attribute attribute = this.attributes.get(i);
                if (!qName.equals(attribute.qName)) continue;
                value = attribute.value;
                break;
            }
        }
        return value;
    }

    public String getValue(String uri, String localName) {
        String value = null;
        if (uri != null && localName != null) {
            int length = this.attributes.size();
            for (int i = 0; i < length; ++i) {
                Attribute attribute = this.attributes.get(i);
                if (!uri.equals(attribute.uri) || !localName.equals(attribute.localName)) continue;
                value = attribute.value;
                break;
            }
        }
        return value;
    }

    protected class Attribute {
        public String uri;
        public String localName;
        public String qName;
        public String type;
        public String value;

        public Attribute(String uri, String localName, String qName, String type, String value) {
            this.uri = uri;
            this.localName = localName;
            this.qName = qName;
            this.type = type;
            this.value = value;
        }
    }
}

