/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.faces.util.product;

import com.liferay.faces.util.product.PackageManifest;
import com.liferay.faces.util.product.Product;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProductBaseImpl
implements Product {
    private static final String REGEX_VERSION_DELIMITER = "[.[-]_]";
    protected int buildId;
    protected boolean detected;
    protected int majorVersion;
    protected int minorVersion;
    protected int revisionVersion;
    protected String stringValue;
    protected String title;
    protected String version;

    @Override
    public String toString() {
        if (this.stringValue == null) {
            StringBuilder buf = new StringBuilder();
            if (this.title != null) {
                buf.append(this.title);
                buf.append(" ");
            }
            if (this.version != null) {
                buf.append(this.version);
            }
            this.stringValue = buf.toString();
        }
        return this.stringValue;
    }

    protected void init(Class<?> clazz, String expectedTitle) {
        Package pkg = clazz.getPackage();
        if (pkg != null && pkg.getImplementationVersion() != null) {
            this.title = pkg.getImplementationTitle();
            this.initVersionInfo(pkg.getImplementationVersion());
        } else {
            PackageManifest packageManifest = new PackageManifest(clazz, expectedTitle);
            this.title = packageManifest.getImplementationTitle();
            this.initVersionInfo(packageManifest.getImplementationVersion());
        }
        if (this.majorVersion > 0) {
            this.detected = true;
        }
    }

    protected void initVersionInfo(String version) {
        this.version = version;
        String[] versionParts = version.split(REGEX_VERSION_DELIMITER);
        if (versionParts != null) {
            if (versionParts.length > 0) {
                this.majorVersion = this.parseInt(versionParts[0]);
            }
            if (versionParts.length > 1) {
                this.minorVersion = this.parseInt(versionParts[1]);
            }
            if (versionParts.length > 2) {
                this.revisionVersion = this.parseInt(versionParts[2]);
            }
        }
    }

    protected int parseInt(String value) {
        int intValue = 0;
        try {
            intValue = Integer.parseInt(value);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return intValue;
    }

    @Override
    public int getBuildId() {
        return this.buildId;
    }

    @Override
    public boolean isDetected() {
        return this.detected;
    }

    @Override
    public int getMajorVersion() {
        return this.majorVersion;
    }

    @Override
    public int getMinorVersion() {
        return this.minorVersion;
    }

    protected Package getPackage() {
        return null;
    }

    @Override
    public int getRevisionVersion() {
        return this.revisionVersion;
    }

    @Override
    public String getTitle() {
        return this.title;
    }

    @Override
    public String getVersion() {
        return this.version;
    }
}

