/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.faces.util.model;

import com.liferay.faces.util.logging.Logger;
import com.liferay.faces.util.logging.LoggerFactory;
import com.liferay.faces.util.model.Paginated;
import com.liferay.faces.util.model.RowMarkerDataModel;
import com.liferay.faces.util.model.Sortable;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class LazyDataModel<E>
extends RowMarkerDataModel<E>
implements Paginated,
Sortable {
    private static final Logger logger = LoggerFactory.getLogger(LazyDataModel.class);
    private int rowCount = -1;
    private int rowIndex = -1;
    private int rowsPerPage;
    private boolean sortAscending = true;
    private String sortColumn;
    private List<E> wrappedData;
    private int wrappedDataStartRowIndex = -1;
    private int wrappedDataFinishRowIndex = -1;

    public abstract int countRows();

    public abstract List<E> findRows(int var1, int var2);

    @Override
    public void reset() {
        this.setRowCount(-1);
        this.setWrappedData(null);
        this.setWrappedDataStartRowIndex(-1);
        this.setWrappedDataFinishRowIndex(-1);
        this.setRowMarks(null);
    }

    public boolean isRowAvailable() {
        int rowIndex = this.getRowIndex();
        return rowIndex >= 0 && rowIndex < this.getRowCount();
    }

    @Override
    public boolean isSortAscending() {
        return this.sortAscending;
    }

    public int getRowCount() {
        if (this.rowCount == -1) {
            this.rowCount = this.countRows();
        }
        return this.rowCount;
    }

    public void setRowCount(int rowCount) {
        this.rowCount = rowCount;
    }

    public E getRowData() {
        if (this.getRowIndex() >= 0) {
            Object wrappedData;
            int adjustedRowIndex = this.getRowIndex() % this.getRowsPerPage();
            if (adjustedRowIndex >= (wrappedData = this.getWrappedData()).size()) {
                logger.error("adjustedRowIndex=[{0}] higher than wrappedData.size=[{1}]", adjustedRowIndex, wrappedData.size());
                return null;
            }
            return this.getWrappedData().get(adjustedRowIndex);
        }
        return null;
    }

    public int getRowIndex() {
        return this.rowIndex;
    }

    public void setRowIndex(int rowIndex) {
        if (rowIndex >= 0) {
            int wrappedDataStartRowIndex = this.getWrappedDataStartRowIndex();
            int wrappedDataFinishRowIndex = this.getWrappedDataFinishRowIndex();
            if (wrappedDataStartRowIndex >= 0 && wrappedDataFinishRowIndex >= 0) {
                int wrappedDataMaxFinishRowIndex = wrappedDataStartRowIndex + this.getRowsPerPage() - 1;
                if (rowIndex < wrappedDataStartRowIndex || rowIndex > wrappedDataMaxFinishRowIndex) {
                    if (logger.isDebugEnabled()) {
                        logger.debug("rowIndex=[" + rowIndex + "] outside the range of cached rows so clearing cache");
                    }
                    this.reset();
                }
            }
        }
        this.rowIndex = rowIndex;
    }

    @Override
    public int getRowsPerPage() {
        return this.rowsPerPage;
    }

    @Override
    public void setRowsPerPage(int rowsPerPage) {
        this.rowsPerPage = rowsPerPage;
    }

    @Override
    public void setSortAscending(boolean sortAscending) {
        if (this.sortAscending != sortAscending) {
            this.reset();
        }
        this.sortAscending = sortAscending;
    }

    @Override
    public String getSortColumn() {
        return this.sortColumn;
    }

    @Override
    public void setSortColumn(String sortColumn) {
        if (this.sortColumn != null && !this.sortColumn.equals(sortColumn)) {
            this.reset();
        }
        this.sortColumn = sortColumn;
    }

    @Override
    public boolean isReset() {
        return this.wrappedData == null;
    }

    public List<E> getWrappedData() {
        if (this.wrappedData == null) {
            int wrappedDataStartRowIndex = this.rowIndex;
            int wrappedDataFinishRowIndex = Math.min(this.rowIndex + this.getRowsPerPage() - 1, this.getRowCount() - 1);
            logger.debug("finding new wrappedDataStartRowIndex=[{0}] wrappedDataFinishRowIndex=[{1}]", wrappedDataStartRowIndex, wrappedDataFinishRowIndex);
            this.setWrappedData(this.findRows(wrappedDataStartRowIndex, wrappedDataFinishRowIndex));
            this.setWrappedDataFinishRowIndex(wrappedDataFinishRowIndex);
            this.setWrappedDataStartRowIndex(wrappedDataStartRowIndex);
        }
        return this.wrappedData;
    }

    public void setWrappedData(Object wrappedData) {
        this.wrappedData = wrappedData == null ? null : (List)wrappedData;
    }

    public int getWrappedDataFinishRowIndex() {
        return this.wrappedDataFinishRowIndex;
    }

    public void setWrappedDataFinishRowIndex(int wrappedDataFinishRowIndex) {
        this.wrappedDataFinishRowIndex = wrappedDataFinishRowIndex;
    }

    public int getWrappedDataStartRowIndex() {
        return this.wrappedDataStartRowIndex;
    }

    public void setWrappedDataStartRowIndex(int wrappedDataStartRowIndex) {
        this.wrappedDataStartRowIndex = wrappedDataStartRowIndex;
    }

    public E getWrappedRow(Object primaryKey) {
        E wrappedRow = null;
        for (E row : this.wrappedData) {
            if (!this.getPrimaryKey(row).equals(primaryKey)) continue;
            wrappedRow = row;
            break;
        }
        return wrappedRow;
    }
}

