/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.faces.util.map;

import com.liferay.faces.util.map.AbstractPropertyMapEntry;
import com.liferay.faces.util.map.PropertyMapEntrySet;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractPropertyMap<V>
implements Map<String, V> {
    @Override
    public void clear() {
        Enumeration<String> propertyNames = this.getPropertyNames();
        if (propertyNames != null) {
            while (propertyNames.hasMoreElements()) {
                this.removeProperty(propertyNames.nextElement());
            }
        }
    }

    @Override
    public boolean containsKey(Object key) {
        boolean found = false;
        if (key != null) {
            String keyAsString = key.toString();
            Enumeration<String> propertyNames = this.getPropertyNames();
            if (propertyNames != null) {
                while (!found && propertyNames.hasMoreElements()) {
                    String propertyName = propertyNames.nextElement();
                    found = propertyName.equals(keyAsString);
                }
            }
        }
        return found;
    }

    @Override
    public boolean containsValue(Object value) {
        boolean found = false;
        Enumeration<String> propertyNames = this.getPropertyNames();
        if (propertyNames != null) {
            while (!found && propertyNames.hasMoreElements()) {
                String propertyName = propertyNames.nextElement();
                V propertyValue = this.getProperty(propertyName);
                if (propertyValue == null) {
                    found = value == null;
                    continue;
                }
                found = propertyValue.equals(value);
            }
        }
        return found;
    }

    @Override
    public Set<Map.Entry<String, V>> entrySet() {
        PropertyMapEntrySet entrySet = null;
        Enumeration<String> propertyNames = this.getPropertyNames();
        if (propertyNames != null) {
            entrySet = new PropertyMapEntrySet();
            while (propertyNames.hasMoreElements()) {
                String name = propertyNames.nextElement();
                AbstractPropertyMapEntry<V> propertyMapEntry = this.createPropertyMapEntry(name);
                entrySet.add(propertyMapEntry);
            }
        }
        return entrySet;
    }

    @Override
    public V get(Object key) {
        V value = null;
        if (key != null) {
            String keyAsString = key.toString();
            value = this.getProperty(keyAsString);
        }
        return value;
    }

    @Override
    public Set<String> keySet() {
        HashSet<String> keySet = null;
        Enumeration<String> propertyNames = this.getPropertyNames();
        if (propertyNames != null) {
            keySet = new HashSet<String>();
            while (propertyNames.hasMoreElements()) {
                String propertyName = propertyNames.nextElement();
                keySet.add(propertyName);
            }
        }
        return keySet;
    }

    @Override
    public V put(String key, V value) {
        V oldValue = this.getProperty(key);
        this.setProperty(key, value);
        return oldValue;
    }

    @Override
    public void putAll(Map<? extends String, ? extends V> t) {
        Set<String> keySet;
        if (t != null && (keySet = t.keySet()) != null) {
            for (String string : keySet) {
                this.setProperty(string, t.get(string));
            }
        }
    }

    @Override
    public V remove(Object key) {
        V oldValue = null;
        if (key != null) {
            String keyAsString = key.toString();
            oldValue = this.getProperty(keyAsString);
            this.removeProperty(keyAsString);
        }
        return oldValue;
    }

    @Override
    public int size() {
        int size = 0;
        Enumeration<String> propertyNames = this.getPropertyNames();
        if (propertyNames != null) {
            while (propertyNames.hasMoreElements()) {
                ++size;
                propertyNames.nextElement();
            }
        }
        return size;
    }

    @Override
    public Collection<V> values() {
        HashSet<V> values = null;
        Enumeration<String> propertyNames = this.getPropertyNames();
        if (propertyNames != null) {
            values = new HashSet<V>();
            while (propertyNames.hasMoreElements()) {
                String propertyName = propertyNames.nextElement();
                V value = this.getProperty(propertyName);
                values.add(value);
            }
        }
        return values;
    }

    protected abstract AbstractPropertyMapEntry<V> createPropertyMapEntry(String var1);

    protected abstract void removeProperty(String var1);

    protected abstract V getProperty(String var1);

    protected abstract void setProperty(String var1, V var2);

    protected abstract Enumeration<String> getPropertyNames();

    @Override
    public boolean isEmpty() {
        Enumeration<String> propertyNames = this.getPropertyNames();
        return propertyNames == null || !propertyNames.hasMoreElements();
    }
}

