/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.faces.util.logging;

import com.liferay.faces.util.logging.LoggerDefaultImpl;
import org.apache.log4j.Level;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;

public class LoggerLog4JImpl
extends LoggerDefaultImpl {
    private static final String CALLING_CLASS_FQCN = LoggerLog4JImpl.class.getName();
    private Logger wrappedLogger;
    private Boolean traceSupported;

    public LoggerLog4JImpl(String className) {
        try {
            StackTraceElement[] stackTraceElements;
            boolean webappContextStopping = false;
            for (StackTraceElement stackTraceElement : stackTraceElements = Thread.currentThread().getStackTrace()) {
                if (!stackTraceElement.getClassName().equals("org.apache.catalina.core.StandardContext") || !stackTraceElement.getMethodName().equals("stop")) continue;
                webappContextStopping = true;
            }
            if (!webappContextStopping) {
                this.wrappedLogger = LogManager.getLogger((String)className);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void debug(String message) {
        if (this.isDebugEnabled()) {
            try {
                this.wrappedLogger.log(CALLING_CLASS_FQCN, (Priority)Level.DEBUG, (Object)message, null);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public void debug(String message, Object ... arguments) {
        if (this.isDebugEnabled()) {
            try {
                String formattedMessage = this.formatMessage(message, arguments);
                Throwable throwable = this.getThrowable(arguments);
                this.wrappedLogger.log(CALLING_CLASS_FQCN, (Priority)Level.DEBUG, (Object)formattedMessage, throwable);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public void error(Throwable throwable) {
        if (this.isErrorEnabled()) {
            try {
                String message = throwable.getMessage();
                this.wrappedLogger.log(CALLING_CLASS_FQCN, (Priority)Level.ERROR, (Object)message, throwable);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public void error(String message) {
        if (this.isErrorEnabled()) {
            try {
                this.wrappedLogger.log(CALLING_CLASS_FQCN, (Priority)Level.ERROR, (Object)message, null);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public void error(String message, Object ... arguments) {
        if (this.isErrorEnabled()) {
            try {
                String formattedMessage = this.formatMessage(message, arguments);
                Throwable throwable = this.getThrowable(arguments);
                this.wrappedLogger.log(CALLING_CLASS_FQCN, (Priority)Level.ERROR, (Object)formattedMessage, throwable);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public void info(String message) {
        if (this.isInfoEnabled()) {
            try {
                this.wrappedLogger.log(CALLING_CLASS_FQCN, (Priority)Level.INFO, (Object)message, null);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public void info(String message, Object ... arguments) {
        if (this.isInfoEnabled()) {
            try {
                String formattedMessage = this.formatMessage(message, arguments);
                Throwable throwable = this.getThrowable(arguments);
                this.wrappedLogger.log(CALLING_CLASS_FQCN, (Priority)Level.INFO, (Object)formattedMessage, throwable);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public void trace(String message) {
        if (this.isTraceSupported()) {
            if (this.isTraceEnabled()) {
                try {
                    this.wrappedLogger.log(CALLING_CLASS_FQCN, (Priority)Level.TRACE, (Object)message, null);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        } else {
            this.debug(message);
        }
    }

    public void trace(String message, Object ... arguments) {
        if (this.isTraceSupported()) {
            if (this.isTraceEnabled()) {
                try {
                    String formattedMessage = this.formatMessage(message, arguments);
                    Throwable throwable = this.getThrowable(arguments);
                    this.wrappedLogger.log(CALLING_CLASS_FQCN, (Priority)Level.TRACE, (Object)formattedMessage, throwable);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        } else {
            this.debug(message, arguments);
        }
    }

    public void warn(String message) {
        if (this.isWarnEnabled()) {
            try {
                this.wrappedLogger.log(CALLING_CLASS_FQCN, (Priority)Level.WARN, (Object)message, null);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public void warn(String message, Object ... arguments) {
        if (this.isWarnEnabled()) {
            try {
                String formattedMessage = this.formatMessage(message, arguments);
                Throwable throwable = this.getThrowable(arguments);
                this.wrappedLogger.log(CALLING_CLASS_FQCN, (Priority)Level.WARN, (Object)formattedMessage, throwable);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public boolean isDebugEnabled() {
        return this.wrappedLogger.isDebugEnabled();
    }

    public boolean isErrorEnabled() {
        return this.wrappedLogger.isEnabledFor((Priority)Level.ERROR);
    }

    public boolean isInfoEnabled() {
        return this.wrappedLogger.isInfoEnabled();
    }

    public boolean isTraceEnabled() {
        return this.wrappedLogger.isTraceEnabled();
    }

    public boolean isWarnEnabled() {
        return this.wrappedLogger.isEnabledFor((Priority)Level.WARN);
    }

    protected boolean isTraceSupported() {
        if (this.traceSupported == null) {
            try {
                this.isTraceEnabled();
                this.traceSupported = Boolean.TRUE;
            }
            catch (NoSuchMethodError e) {
                this.traceSupported = Boolean.FALSE;
            }
        }
        return this.traceSupported;
    }
}

