/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.faces.util.logging;

import com.liferay.faces.util.logging.Logger;
import com.liferay.faces.util.logging.LoggerDefaultImpl;
import com.liferay.faces.util.logging.LoggerLog4JImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LoggerFactory {
    private static final String CLASS_NAME_LOG4J_LOGGER = "org.apache.log4j.Logger";
    private static boolean LOG4J_AVAILABLE = false;

    public static final Logger getLogger(String name) {
        LoggerDefaultImpl logger = null;
        try {
            if (LOG4J_AVAILABLE) {
                logger = new LoggerLog4JImpl(name);
            }
        }
        catch (NoClassDefFoundError e) {
            System.err.println("com.liferay.faces.bridge.logging.LoggerFactory (WARN): Possibly an incompatible version of log4j.jar in the classpath: " + e.getMessage());
        }
        if (logger == null) {
            logger = new LoggerDefaultImpl(name);
        }
        return logger;
    }

    public static final Logger getLogger(Class<?> clazz) {
        return LoggerFactory.getLogger(clazz.getName());
    }

    static {
        try {
            Class.forName(CLASS_NAME_LOG4J_LOGGER);
            LOG4J_AVAILABLE = true;
        }
        catch (Exception e) {
            LOG4J_AVAILABLE = false;
        }
    }
}

