/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.faces.util.lang;

import com.liferay.faces.util.lang.Observable;
import com.liferay.faces.util.lang.Observer;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ObservableList<E>
implements List<E>,
Observable {
    private List<Observer> observerList;
    private List<E> wrappedList;

    public ObservableList(List<E> list, List<Observer> observerList) {
        this.wrappedList = list;
        this.observerList = observerList;
    }

    @Override
    public boolean add(E e) {
        boolean result = this.wrappedList.add(e);
        this.notifyObservers(new Object[]{Action.ADD, e});
        return result;
    }

    @Override
    public void add(int index, E e) {
        this.wrappedList.add(index, e);
        this.notifyObservers(new Object[]{Action.ADD, e});
    }

    @Override
    public boolean addAll(Collection<? extends E> c) {
        boolean all = this.wrappedList.addAll(c);
        this.notifyObservers(new Object[]{Action.ADD_ALL, c});
        return all;
    }

    @Override
    public boolean addAll(int index, Collection<? extends E> c) {
        boolean all = this.wrappedList.addAll(c);
        this.notifyObservers(new Object[]{Action.ADD_ALL, c});
        return all;
    }

    @Override
    public void addObserver(Observer observer) {
        this.observerList.add(observer);
    }

    @Override
    public void clear() {
        this.wrappedList.clear();
        this.notifyObservers(new Object[]{Action.CLEAR});
    }

    @Override
    public boolean contains(Object o) {
        return this.wrappedList.contains(o);
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        return this.wrappedList.containsAll(c);
    }

    @Override
    public E get(int index) {
        return this.wrappedList.get(index);
    }

    @Override
    public int indexOf(Object o) {
        return this.wrappedList.indexOf(o);
    }

    @Override
    public Iterator<E> iterator() {
        return this.wrappedList.iterator();
    }

    @Override
    public int lastIndexOf(Object o) {
        return this.wrappedList.lastIndexOf(o);
    }

    @Override
    public ListIterator<E> listIterator() {
        return this.wrappedList.listIterator();
    }

    @Override
    public ListIterator<E> listIterator(int index) {
        return this.wrappedList.listIterator(index);
    }

    @Override
    public void notifyObservers(Object ... args) {
        for (Observer observer : this.observerList) {
            observer.receiveNotification(this, args);
        }
    }

    @Override
    public boolean remove(Object o) {
        boolean result = this.wrappedList.remove(o);
        this.notifyObservers(new Object[]{Action.REMOVE, o});
        return result;
    }

    @Override
    public E remove(int index) {
        E e = this.wrappedList.remove(index);
        this.notifyObservers(new Object[]{Action.REMOVE, e});
        return e;
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        boolean result = this.wrappedList.removeAll(c);
        this.notifyObservers(new Object[]{Action.REMOVE_ALL, c});
        return result;
    }

    @Override
    public void removeObserver(Observer observer) {
        this.observerList.remove(observer);
        this.notifyObservers(new Object[]{Action.REMOVE, observer});
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        boolean result = this.wrappedList.retainAll(c);
        this.notifyObservers(new Object[]{Action.RETAIN_ALL, c});
        return result;
    }

    @Override
    public E set(int index, E e) {
        E result = this.wrappedList.set(index, e);
        this.notifyObservers(new Object[]{Action.SET, index, e});
        return result;
    }

    @Override
    public int size() {
        return this.wrappedList.size();
    }

    @Override
    public List<E> subList(int fromIndex, int toIndex) {
        return this.wrappedList.subList(fromIndex, toIndex);
    }

    @Override
    public Object[] toArray() {
        return this.wrappedList.toArray();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        return this.wrappedList.toArray(a);
    }

    @Override
    public boolean isEmpty() {
        return this.wrappedList.isEmpty();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Action {
        ADD,
        ADD_ALL,
        CLEAR,
        REMOVE,
        REMOVE_ALL,
        RETAIN_ALL,
        SET;

    }
}

