/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.faces.util.context;

import com.liferay.faces.util.component.UICleanup;
import com.liferay.faces.util.context.ExtFacesContext;
import com.liferay.faces.util.context.PartialResponseWriterWrapper;
import com.liferay.faces.util.logging.Logger;
import com.liferay.faces.util.logging.LoggerFactory;
import com.liferay.faces.util.product.Product;
import com.liferay.faces.util.product.ProductMap;
import java.io.IOException;
import java.util.Collection;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.faces.FactoryFinder;
import javax.faces.component.UIComponent;
import javax.faces.component.visit.VisitCallback;
import javax.faces.component.visit.VisitContext;
import javax.faces.component.visit.VisitContextFactory;
import javax.faces.component.visit.VisitHint;
import javax.faces.component.visit.VisitResult;
import javax.faces.context.FacesContext;
import javax.faces.context.PartialResponseWriter;
import javax.faces.context.PartialViewContext;
import javax.faces.context.PartialViewContextWrapper;
import javax.faces.event.PhaseId;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PartialViewContextCleanupImpl
extends PartialViewContextWrapper {
    private static final boolean ICEFACES_DETECTED = ((Product)ProductMap.getInstance().get("ICEfaces")).isDetected();
    private static final Logger logger = LoggerFactory.getLogger(PartialViewContextCleanupImpl.class);
    private FacesContext facesContext;
    private PartialViewContext wrappedPartialViewContext;
    private PartialResponseWriter partialResponseWriter;

    public PartialViewContextCleanupImpl(PartialViewContext partialViewContext, FacesContext facesContext) {
        this.wrappedPartialViewContext = partialViewContext;
        this.facesContext = facesContext;
    }

    public void processPartial(PhaseId phaseId) {
        if (phaseId == PhaseId.RENDER_RESPONSE) {
            try {
                if (this.isRenderAll()) {
                    this.cleanupAll(this.facesContext);
                } else {
                    this.cleanupPartial(this.facesContext, this.wrappedPartialViewContext.getRenderIds());
                }
                this.wrappedPartialViewContext.processPartial(phaseId);
            }
            catch (IOException e) {
                logger.error(e);
                throw new RuntimeException(e);
            }
        } else {
            this.wrappedPartialViewContext.processPartial(phaseId);
        }
    }

    protected void cleanupAll(FacesContext facesContext) throws IOException {
        this.encodeCleanup(facesContext, (UIComponent)facesContext.getViewRoot(), true);
    }

    protected void cleanupPartial(FacesContext facesContext, Collection<String> renderIds) {
        if (renderIds != null && renderIds.size() > 0) {
            VisitContextFactory visitContextFactory = (VisitContextFactory)FactoryFinder.getFactory((String)"javax.faces.component.visit.VisitContextFactory");
            EnumSet<VisitHint> visitHints = EnumSet.of(VisitHint.EXECUTE_LIFECYCLE);
            VisitContext visitContext = visitContextFactory.getVisitContext(facesContext, renderIds, visitHints);
            VisitCallbackCleanupImpl visitCallback = new VisitCallbackCleanupImpl();
            facesContext.getViewRoot().visitTree(visitContext, (VisitCallback)visitCallback);
        }
    }

    protected void encodeCleanup(FacesContext facesContext, UIComponent uiComponent, boolean parentRendered) throws IOException {
        boolean rendered;
        uiComponent.pushComponentToEL(facesContext, uiComponent);
        boolean bl = rendered = parentRendered && uiComponent.isRendered();
        if (uiComponent instanceof UICleanup) {
            UICleanup uiCleanup = (UICleanup)uiComponent;
            if (!rendered) {
                uiCleanup.encodeCleanup(facesContext);
            }
        } else {
            Iterator itr = uiComponent.getFacetsAndChildren();
            while (itr.hasNext()) {
                UIComponent childUIComponet = (UIComponent)itr.next();
                this.encodeCleanup(facesContext, childUIComponet, rendered);
            }
        }
        uiComponent.popComponentFromEL(facesContext);
    }

    public void setPartialRequest(boolean isPartialRequest) {
        this.wrappedPartialViewContext.setPartialRequest(isPartialRequest);
    }

    public PartialResponseWriter getPartialResponseWriter() {
        if (ICEFACES_DETECTED) {
            return super.getPartialResponseWriter();
        }
        if (this.partialResponseWriter == null) {
            this.partialResponseWriter = new PartialResponseWriterCleanupImpl(super.getPartialResponseWriter());
        }
        return this.partialResponseWriter;
    }

    public PartialViewContext getWrapped() {
        return this.wrappedPartialViewContext;
    }

    protected class VisitCallbackCleanupImpl
    implements VisitCallback {
        protected VisitCallbackCleanupImpl() {
        }

        public VisitResult visit(VisitContext visitContext, UIComponent uiComponent) {
            boolean parentRendered = true;
            UIComponent parentUIComponent = uiComponent.getParent();
            if (parentUIComponent != null) {
                parentUIComponent.pushComponentToEL(PartialViewContextCleanupImpl.this.facesContext, parentUIComponent);
                parentRendered = parentUIComponent.isRendered();
            }
            try {
                PartialViewContextCleanupImpl.this.encodeCleanup(PartialViewContextCleanupImpl.this.facesContext, uiComponent, parentRendered);
            }
            catch (IOException e) {
                logger.error(e);
            }
            if (parentUIComponent != null) {
                parentUIComponent.popComponentFromEL(PartialViewContextCleanupImpl.this.facesContext);
            }
            return VisitResult.REJECT;
        }
    }

    protected class PartialResponseWriterCleanupImpl
    extends PartialResponseWriterWrapper {
        public PartialResponseWriterCleanupImpl(PartialResponseWriter partialResponseWriter) {
            super(partialResponseWriter);
        }

        public void endDocument() throws IOException {
            ExtFacesContext extFacesContext = ExtFacesContext.getInstance();
            Map javaScriptMap = extFacesContext.getJavaScriptMap();
            if (javaScriptMap.size() > 0) {
                Set entrySet = javaScriptMap.entrySet();
                super.startEval();
                for (Map.Entry mapEntry : entrySet) {
                    super.write((String)mapEntry.getValue());
                }
                super.endEval();
            }
            super.endDocument();
        }
    }
}

