/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.faces.bridge.servlet;

import com.liferay.faces.bridge.BridgeFactoryFinder;
import com.liferay.faces.bridge.application.MojarraApplicationAssociate;
import com.liferay.faces.bridge.bean.BeanManager;
import com.liferay.faces.bridge.bean.BeanManagerFactory;
import com.liferay.faces.bridge.bean.MojarraInjectionProvider;
import com.liferay.faces.bridge.scope.BridgeRequestScopeManager;
import com.liferay.faces.bridge.scope.BridgeRequestScopeManagerFactory;
import com.liferay.faces.util.logging.Logger;
import com.liferay.faces.util.logging.LoggerFactory;
import com.liferay.faces.util.product.Product;
import com.liferay.faces.util.product.ProductMap;
import java.util.Enumeration;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.portlet.faces.BridgeException;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpSessionEvent;
import javax.servlet.http.HttpSessionListener;

public class BridgeSessionListener
implements HttpSessionListener,
ServletContextListener {
    private static final Logger logger = LoggerFactory.getLogger(BridgeSessionListener.class);
    private static final String MOJARRA_ACTIVE_VIEW_MAPS = "com.sun.faces.application.view.activeViewMaps";
    private static final String MOJARRA_PACKAGE_PREFIX = "com.sun.faces";
    private static final String MOJARRA_VIEW_SCOPE_MANAGER = "com.sun.faces.application.view.viewScopeManager";
    private static String servletContextPath;
    private static MojarraInjectionProvider mojarraInjectionProvider;
    private boolean firstInstance;
    private ServletContext servletContext;

    public static MojarraInjectionProvider getMojarraInjectionProvider() {
        return mojarraInjectionProvider;
    }

    public static synchronized void setMojarraInjectionProvider(MojarraInjectionProvider injectionProvider) {
        mojarraInjectionProvider = injectionProvider;
    }

    public static String getServletContextPath() {
        return servletContextPath;
    }

    public void contextDestroyed(ServletContextEvent servletContextEvent) {
        this.servletContext = null;
    }

    public void contextInitialized(ServletContextEvent servletContextEvent) {
        this.servletContext = servletContextEvent.getServletContext();
        if (this.servletContext.getAttribute(BridgeSessionListener.class.getName()) == null) {
            Product jsf;
            logger.info("Context initialized for contextPath=[{0}]", new Object[]{this.servletContext.getContextPath()});
            this.servletContext.setAttribute(BridgeSessionListener.class.getName(), (Object)Boolean.TRUE);
            this.firstInstance = true;
            if (servletContextPath == null) {
                servletContextPath = this.servletContext.getContextPath();
            }
            if (mojarraInjectionProvider == null && (jsf = (Product)ProductMap.getInstance().get((Object)"JSF")).isDetected() && "Mojarra".equals(jsf.getTitle())) {
                FacesContext facesContext = FacesContext.getCurrentInstance();
                if (facesContext != null) {
                    ExternalContext externalContext = facesContext.getExternalContext();
                    mojarraInjectionProvider = MojarraApplicationAssociate.getInjectionProvider(externalContext);
                }
                if (mojarraInjectionProvider == null) {
                    logger.debug("Unable to discover Mojarra InjectionProvider during startup");
                } else {
                    logger.debug("Mojarra injectionProvider=[{0}]", new Object[]{mojarraInjectionProvider});
                }
            }
        } else {
            logger.debug("Preventing multiple instantiation for contextPath=[{0}]", new Object[]{this.servletContext.getContextPath()});
        }
    }

    public void sessionCreated(HttpSessionEvent httpSessionEvent) {
    }

    public void sessionDestroyed(HttpSessionEvent httpSessionEvent) {
        if (this.firstInstance) {
            ProductMap productMap = ProductMap.getInstance();
            Product jsf = (Product)productMap.get((Object)"JSF");
            boolean mojarraAbleToCleanup = true;
            if (jsf.getTitle().equals("Mojarra") && jsf.getMajorVersion() == 2 && jsf.getMinorVersion() == 1 && jsf.getRevisionVersion() < 18) {
                mojarraAbleToCleanup = false;
                boolean logWarning = true;
                Product iceFaces = (Product)productMap.get((Object)"ICEfaces");
                if (iceFaces.isDetected() && (iceFaces.getMajorVersion() == 2 || iceFaces.getMajorVersion() == 3 && iceFaces.getMinorVersion() <= 2)) {
                    logWarning = false;
                }
                if (logWarning) {
                    logger.warn("Unable to cleanup ViewScoped managed-beans upon session expiration. Please upgrade to Mojarra 2.1.18 or newer. For more info, see: http://issues.liferay.com/browse/FACES-1470");
                }
            }
            BeanManagerFactory beanManagerFactory = null;
            BridgeRequestScopeManagerFactory bridgeRequestScopeManagerFactory = null;
            try {
                beanManagerFactory = (BeanManagerFactory)BridgeFactoryFinder.getFactory(BeanManagerFactory.class);
                bridgeRequestScopeManagerFactory = (BridgeRequestScopeManagerFactory)BridgeFactoryFinder.getFactory(BridgeRequestScopeManagerFactory.class);
            }
            catch (BridgeException e) {
                logger.debug("Unable to discover factories because portlet never received a RenderRequest");
            }
            if (beanManagerFactory != null && bridgeRequestScopeManagerFactory != null) {
                HttpSession httpSession = httpSessionEvent.getSession();
                BridgeRequestScopeManager bridgeRequestScopeManager = bridgeRequestScopeManagerFactory.getBridgeRequestScopeManager();
                bridgeRequestScopeManager.removeBridgeRequestScopesBySession(httpSession);
                BeanManager beanManager = beanManagerFactory.getBeanManager();
                try {
                    Enumeration attributeNames = httpSession.getAttributeNames();
                    while (attributeNames.hasMoreElements()) {
                        HttpSessionListener viewScopeManager;
                        int pos;
                        String attributeName = (String)attributeNames.nextElement();
                        if (attributeName == null || !attributeName.startsWith("javax.portlet.p.") || (pos = attributeName.indexOf("?")) <= 0) continue;
                        Object attributeValue = httpSession.getAttribute(attributeName);
                        httpSession.removeAttribute(attributeName);
                        if (attributeValue == null) continue;
                        if (beanManager.isManagedBean(attributeName, attributeValue)) {
                            beanManager.invokePreDestroyMethods(attributeValue, true);
                            continue;
                        }
                        String fqcn = attributeValue.getClass().getName();
                        if (fqcn == null || !fqcn.contains(MOJARRA_PACKAGE_PREFIX)) continue;
                        String nonPrefixedName = attributeName.substring(pos + 1);
                        logger.debug("Renaming Mojarra session attributeName=[{0}] -> [{1}]", new Object[]{attributeName, nonPrefixedName});
                        httpSession.setAttribute(nonPrefixedName, attributeValue);
                        if (!MOJARRA_ACTIVE_VIEW_MAPS.equals(nonPrefixedName) || !mojarraAbleToCleanup || (viewScopeManager = (HttpSessionListener)this.servletContext.getAttribute(MOJARRA_VIEW_SCOPE_MANAGER)) == null) continue;
                        try {
                            logger.debug("Asking Mojarra ViewScopeManager to cleanup @ViewScoped managed-beans");
                            viewScopeManager.sessionDestroyed(httpSessionEvent);
                        }
                        catch (Exception e) {
                            logger.error((Throwable)e);
                        }
                    }
                }
                catch (IllegalStateException e) {
                    logger.warn("Server does not permit cleanup of Mojarra managed-beans during session expiration");
                }
            }
        }
    }
}

