/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.faces.bridge.renderkit.richfaces;

import com.liferay.faces.bridge.model.UploadedFile;
import com.liferay.faces.util.logging.Logger;
import com.liferay.faces.util.logging.LoggerFactory;
import com.liferay.faces.util.render.RendererWrapper;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.List;
import java.util.Map;
import javax.faces.component.UIComponent;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.faces.event.FacesEvent;
import javax.faces.render.Renderer;

public class FileUploadRendererRichFacesImpl
extends RendererWrapper {
    private static final Logger logger = LoggerFactory.getLogger(FileUploadRendererRichFacesImpl.class);
    private static final String RICHFACES_UPLOADED_FILE_FQCN = "org.richfaces.model.UploadedFile";
    private static final String RICHFACES_FILE_UPLOAD_EVENT_FQCN = "org.richfaces.event.FileUploadEvent";
    private Renderer wrappedRenderer;

    public FileUploadRendererRichFacesImpl(Renderer renderer) {
        this.wrappedRenderer = renderer;
    }

    public void decode(FacesContext facesContext, UIComponent uiComponent) {
        try {
            String clientId = uiComponent.getClientId(facesContext);
            ExternalContext externalContext = facesContext.getExternalContext();
            Map requestAttributeMap = externalContext.getRequestMap();
            Map uploadedFilesMap = (Map)requestAttributeMap.get("com.liferay.faces.bridge.UPLOADED_FILES");
            if (uploadedFilesMap != null) {
                Class<?> uploadedFileInterface = Class.forName(RICHFACES_UPLOADED_FILE_FQCN);
                Class<?> fileUploadEventClass = Class.forName(RICHFACES_FILE_UPLOAD_EVENT_FQCN);
                ClassLoader classLoader = uploadedFileInterface.getClassLoader();
                List uploadedFiles = (List)uploadedFilesMap.get(clientId);
                if (uploadedFiles != null) {
                    for (UploadedFile uploadedFile : uploadedFiles) {
                        RichFacesUploadedFileHandler richFacesUploadedFileHandler = new RichFacesUploadedFileHandler(uploadedFile);
                        Object richFacesUploadedFile = Proxy.newProxyInstance(classLoader, new Class[]{uploadedFileInterface}, (InvocationHandler)richFacesUploadedFileHandler);
                        FacesEvent fileUploadEvent = (FacesEvent)fileUploadEventClass.getConstructor(UIComponent.class, uploadedFileInterface).newInstance(uiComponent, richFacesUploadedFile);
                        uiComponent.queueEvent(fileUploadEvent);
                    }
                }
            }
        }
        catch (Exception e) {
            logger.error((Throwable)e);
        }
    }

    public Renderer getWrapped() {
        return this.wrappedRenderer;
    }

    public class RichFacesUploadedFileHandler
    implements InvocationHandler {
        private static final String METHOD_DELETE = "delete";
        private static final String METHOD_GET_CONTENT_TYPE = "getContentType";
        private static final String METHOD_GET_DATA = "getData";
        private static final String METHOD_GET_INPUT_STREAM = "getInputStream";
        private static final String METHOD_GET_NAME = "getName";
        private static final String METHOD_GET_SIZE = "getSize";
        private static final String METHOD_WRITE = "write";
        private UploadedFile uploadedFile;

        public RichFacesUploadedFileHandler(UploadedFile uploadedFile) {
            this.uploadedFile = uploadedFile;
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            String methodName = method.getName();
            if (METHOD_DELETE.equals(methodName)) {
                File file = new File(this.uploadedFile.getAbsolutePath());
                file.delete();
                return null;
            }
            if (METHOD_GET_CONTENT_TYPE.equals(methodName)) {
                return this.uploadedFile.getContentType();
            }
            if (METHOD_GET_DATA.equals(methodName)) {
                return this.getBytes();
            }
            if (METHOD_GET_INPUT_STREAM.equals(methodName)) {
                return new FileInputStream(this.uploadedFile.getAbsolutePath());
            }
            if (METHOD_GET_NAME.equals(methodName)) {
                return this.uploadedFile.getName();
            }
            if (METHOD_GET_SIZE.equals(methodName)) {
                return this.uploadedFile.getSize();
            }
            if (METHOD_WRITE.equals(methodName)) {
                String fileName = (String)args[0];
                FileOutputStream outputStream = new FileOutputStream(fileName);
                ((OutputStream)outputStream).write(this.getBytes());
                ((OutputStream)outputStream).close();
                return null;
            }
            return null;
        }

        protected byte[] getBytes() {
            byte[] bytes = null;
            try {
                File file = new File(this.uploadedFile.getAbsolutePath());
                if (file.exists()) {
                    RandomAccessFile randomAccessFile = new RandomAccessFile(file, "r");
                    bytes = new byte[(int)randomAccessFile.length()];
                    randomAccessFile.readFully(bytes);
                    randomAccessFile.close();
                }
            }
            catch (Exception e) {
                logger.error((Throwable)e);
            }
            return bytes;
        }
    }
}

