/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.faces.bridge.renderkit.primefaces;

import com.liferay.faces.bridge.model.UploadedFile;
import com.liferay.faces.bridge.renderkit.primefaces.UploadedFileInputStream;
import com.liferay.faces.util.logging.Logger;
import com.liferay.faces.util.logging.LoggerFactory;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.io.UnsupportedEncodingException;
import org.apache.commons.fileupload.FileItem;

public class PrimeFacesFileItem
implements FileItem {
    private static final long serialVersionUID = 4243775660521293895L;
    private static final Logger logger = LoggerFactory.getLogger(PrimeFacesFileItem.class);
    private String clientId;
    private UploadedFile uploadedFile;

    public PrimeFacesFileItem(String clientId, UploadedFile uploadedFile) {
        this.clientId = clientId;
        this.uploadedFile = uploadedFile;
    }

    public void delete() {
        throw new UnsupportedOperationException();
    }

    public byte[] get() {
        byte[] bytes = null;
        try {
            File file = new File(this.uploadedFile.getAbsolutePath());
            if (file.exists()) {
                RandomAccessFile randomAccessFile = new RandomAccessFile(file, "r");
                bytes = new byte[(int)randomAccessFile.length()];
                randomAccessFile.readFully(bytes);
                randomAccessFile.close();
                file.delete();
            }
        }
        catch (Exception e) {
            logger.error((Throwable)e);
        }
        return bytes;
    }

    public void write(File file) throws Exception {
        throw new UnsupportedOperationException();
    }

    public String getContentType() {
        return this.uploadedFile.getContentType();
    }

    public boolean isFormField() {
        return false;
    }

    public String getFieldName() {
        return this.clientId;
    }

    public void setFieldName(String name) {
        this.clientId = name;
    }

    public void setFormField(boolean state) {
        throw new UnsupportedOperationException();
    }

    public InputStream getInputStream() throws IOException {
        return new UploadedFileInputStream(this.uploadedFile.getAbsolutePath());
    }

    public String getName() {
        return this.uploadedFile.getName();
    }

    public OutputStream getOutputStream() throws IOException {
        throw new UnsupportedOperationException();
    }

    public long getSize() {
        return this.uploadedFile.getSize();
    }

    public String getString() {
        return this.getString("UTF-8");
    }

    public String getString(String encoding) {
        String stringValue = null;
        byte[] bytes = this.get();
        if (bytes != null) {
            try {
                stringValue = new String(bytes, encoding);
            }
            catch (UnsupportedEncodingException e) {
                logger.error((Throwable)e);
            }
        }
        return stringValue;
    }

    public boolean isInMemory() {
        return false;
    }
}

