/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.faces.bridge.renderkit.primefaces;

import com.liferay.faces.bridge.component.primefaces.PrimeFacesFileUpload;
import com.liferay.faces.util.render.RendererWrapper;
import java.io.IOException;
import java.util.List;
import javax.faces.component.UIComponent;
import javax.faces.component.UIInput;
import javax.faces.context.FacesContext;
import javax.faces.render.Renderer;

public class FormRendererPrimeFacesImpl
extends RendererWrapper {
    private static final String ENCTYPE = "enctype";
    private static final String MULTIPART = "multipart";
    private Renderer wrappedRenderer;

    public FormRendererPrimeFacesImpl(Renderer renderer) {
        this.wrappedRenderer = renderer;
    }

    public void encodeBegin(FacesContext facesContext, UIComponent uiComponent) throws IOException {
        if (this.isMultiPartForm(uiComponent)) {
            PrimeFacesFileUpload primeFacesFileUpload;
            boolean hasPrimeFacesAjaxFileUploadChild = false;
            UIComponent childComponent = this.getChildWithRendererType(uiComponent, "org.primefaces.component.FileUploadRenderer");
            if (childComponent != null && !(primeFacesFileUpload = new PrimeFacesFileUpload((UIInput)childComponent)).getMode().equals("simple")) {
                hasPrimeFacesAjaxFileUploadChild = true;
                facesContext.getAttributes().put("ajax.file.upload", Boolean.TRUE);
            }
            super.encodeBegin(facesContext, uiComponent);
            if (hasPrimeFacesAjaxFileUploadChild) {
                facesContext.getAttributes().remove("ajax.file.upload");
            }
        } else {
            super.encodeBegin(facesContext, uiComponent);
        }
    }

    protected UIComponent getChildWithRendererType(UIComponent uiComponent, String rendererType) {
        UIComponent childWithRendererType = null;
        List children = uiComponent.getChildren();
        if (children != null) {
            for (UIComponent uiComponentChild : children) {
                if (rendererType.equals(uiComponentChild.getRendererType())) {
                    childWithRendererType = uiComponentChild;
                    break;
                }
                childWithRendererType = this.getChildWithRendererType(uiComponentChild, rendererType);
                if (childWithRendererType == null) continue;
                break;
            }
        }
        return childWithRendererType;
    }

    protected boolean isMultiPartForm(UIComponent uiComponent) {
        String enctype = (String)uiComponent.getAttributes().get(ENCTYPE);
        return enctype != null && enctype.toLowerCase().indexOf(MULTIPART) >= 0;
    }

    public Renderer getWrapped() {
        return this.wrappedRenderer;
    }
}

