/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.faces.bridge.renderkit.html_basic;

import com.liferay.faces.bridge.util.FacesURLEncoder;
import java.io.IOException;
import javax.faces.component.UIComponent;
import javax.faces.context.ResponseWriter;
import javax.faces.context.ResponseWriterWrapper;

public class ResponseWriterResourceImpl
extends ResponseWriterWrapper {
    private static final String REGEX_AMPERSAND = "[&]amp;";
    private ResponseWriter wrappedResponseWriter;

    public ResponseWriterResourceImpl(ResponseWriter responseWriter) {
        this.wrappedResponseWriter = responseWriter;
    }

    public void endElement(String name) throws IOException {
        this.write(">");
        this.write("<");
        this.write("/");
        this.write(name);
        this.write(">");
    }

    public void startElement(String name, UIComponent component) throws IOException {
        this.write("<");
        this.write(name);
    }

    public void write(String str) throws IOException {
        super.write(str);
    }

    public void writeAttribute(String name, Object value, String property) throws IOException {
        this.write(" ");
        this.write(name);
        this.write("=");
        this.write("\"");
        this.write((String)value);
        this.write("\"");
    }

    public void writeURIAttribute(String name, Object value, String property) throws IOException {
        if (value != null && value instanceof String) {
            String encoding = this.wrappedResponseWriter.getCharacterEncoding();
            String encodedURI = FacesURLEncoder.encode((String)value, encoding);
            if (encodedURI != null) {
                encodedURI = encodedURI.replaceAll(REGEX_AMPERSAND, "&");
            }
            this.writeAttribute(name, encodedURI, property);
        } else {
            this.writeAttribute(name, value, property);
        }
    }

    public ResponseWriter getWrapped() {
        return this.wrappedResponseWriter;
    }
}

